/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.npc;

import JinRyuu.DragonBC.common.Npcs.EntityAura2;
import JinRyuu.JRMCore.entity.EntityCusPar;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.npc.IDBCDisplay;
import kamkeel.npcdbc.api.npc.IKiWeaponData;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.config.ConfigDBCGeneral;
import kamkeel.npcdbc.constants.DBCRace;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.controllers.TransformController;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.npc.KiWeaponData;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.entity.EntityAura;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.mixins.late.INPCStats;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.ModelData;
import noppes.npcs.entity.data.ModelPartData;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.util.ValueUtil;

public class DBCDisplay
implements IDBCDisplay,
IAuraData {
    public static Form fakeForm;
    public final EntityNPCInterface npc;
    public boolean enabled = ConfigDBCGeneral.DISPLAY_BY_DEFAULT;
    public String hairCode = "025050545050210250505450501801505045505021025050475050180147507467503248505072675043255250726750360150505667501922475071675038255050716750380152507167503202475071675032025250716750300050507167503000505047655036205250276550362250502765503620475027655036225250306550363150503065503622475030655034015250276550250147502765503000505027655036175050505050803150505050508028505050505080225050505050801750505050508022505050505080255050505050801750505050508000505050505080005050505050800050505050508000505050505080005050505050800050505050508000505050505080005050505050803154508067504931545080615028285450766150472854506561506551525080675038655250806150786052507861503451525069615050625050806950528250508061503485505078615030625050696150585149508069506157495080615080624950786150805149506961504920";
    public String hairType = "";
    public int hairColor = 0;
    public byte race = 1;
    public boolean useSkin = false;
    public int bodyType = 0;
    public int bodyCM = 0xFFFFFF;
    public int bodyC1 = 0xFFFFFF;
    public int bodyC2 = 0xFFFFFF;
    public int bodyC3 = 0xFFFFFF;
    public boolean hasArcoMask = false;
    public boolean hasEyebrows = true;
    public int furColor = -1;
    public boolean hasFur = false;
    public byte tailState;
    public int eyeColor = 0;
    public int noseType = 0;
    public int mouthType = 0;
    public int eyeType = 0;
    public int arcoState;
    public boolean auraOn = false;
    public int auraID = -1;
    public int formID = -1;
    public int selectedForm = -1;
    public int rage;
    public float formLevel = 0.0f;
    public boolean isTransforming;
    public boolean isKaioken;
    public int outlineID;
    public float rageValue;
    public int tempState;
    public int stateChange;
    public int state2Change;
    public int auraTime;
    public int auraType;
    public int bendTime;
    public boolean useStencilBuffer;
    public EntityAura auraEntity;
    public int activeAuraColor = -1;
    public List<EntityCusPar> particleRenderQueue = new LinkedList<EntityCusPar>();
    public HashMap<Integer, EntityAura2> dbcAuraQueue = new HashMap();
    public HashMap<Integer, EntityAura2> dbcSecondaryAuraQueue = new HashMap();
    public KiWeaponData kiWeaponRight = new KiWeaponData();
    public KiWeaponData kiWeaponLeft = new KiWeaponData();

    public DBCDisplay(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound comp) {
        comp.func_74757_a("DBCDisplayEnabled", this.enabled);
        if (this.enabled) {
            NBTTagCompound dbcDisplay = new NBTTagCompound();
            dbcDisplay.func_74778_a("DBCHair", this.hairCode);
            dbcDisplay.func_74768_a("DBCHairColor", this.hairColor);
            dbcDisplay.func_74768_a("DBCEyeColor", this.eyeColor);
            dbcDisplay.func_74778_a("DBCHairType", this.hairType);
            dbcDisplay.func_74768_a("DBCEyeType", this.eyeType);
            dbcDisplay.func_74768_a("DBCMouthType", this.mouthType);
            dbcDisplay.func_74768_a("DBCNoseType", this.noseType);
            dbcDisplay.func_74768_a("DBCBodyType", this.bodyType);
            dbcDisplay.func_74774_a("DBCTailState", this.tailState);
            dbcDisplay.func_74768_a("DBCRace", (int)this.race);
            dbcDisplay.func_74757_a("DBCUseSkin", this.useSkin);
            dbcDisplay.func_74768_a("DBCBodyCM", this.bodyCM);
            dbcDisplay.func_74768_a("DBCBodyC1", this.bodyC1);
            dbcDisplay.func_74768_a("DBCBodyC2", this.bodyC2);
            dbcDisplay.func_74768_a("DBCBodyC3", this.bodyC3);
            dbcDisplay.func_74768_a("DBCFurColor", this.furColor);
            dbcDisplay.func_74768_a("DBCArcoState", this.arcoState);
            dbcDisplay.func_74757_a("DBCArcoMask", this.hasArcoMask);
            dbcDisplay.func_74757_a("DBCFur", this.hasFur);
            dbcDisplay.func_74757_a("DBCHasEyebrows", this.hasEyebrows);
            dbcDisplay.func_74768_a("DBCRage", this.rage);
            dbcDisplay.func_74757_a("DBCIsTransforming", this.isTransforming);
            dbcDisplay.func_74757_a("DBCIsKaioken", this.isKaioken);
            dbcDisplay.func_74768_a("DBCFormID", this.formID);
            dbcDisplay.func_74776_a("DBCFormLevel", this.formLevel);
            dbcDisplay.func_74768_a("DBCSelectedForm", this.selectedForm);
            dbcDisplay.func_74768_a("DBCAuraID", this.auraID);
            dbcDisplay.func_74757_a("DBCAuraOn", this.auraOn);
            dbcDisplay.func_74768_a("DBCOutlineID", this.outlineID);
            this.kiWeaponLeft.saveToNBT(dbcDisplay, "kiWeaponLeft");
            this.kiWeaponRight.saveToNBT(dbcDisplay, "kiWeaponRight");
            comp.func_74782_a("DBCDisplay", (NBTBase)dbcDisplay);
        } else {
            comp.func_82580_o("DBCDisplay");
        }
        return comp;
    }

    public void readFromNBT(NBTTagCompound comp) {
        this.enabled = comp.func_74767_n("DBCDisplayEnabled");
        if (this.enabled) {
            NBTTagCompound dbcDisplay = comp.func_74775_l("DBCDisplay");
            this.race = dbcDisplay.func_74771_c("DBCRace");
            this.auraID = dbcDisplay.func_74762_e("DBCAuraID");
            this.auraOn = dbcDisplay.func_74767_n("DBCAuraOn");
            this.useSkin = dbcDisplay.func_74767_n("DBCUseSkin");
            this.hairCode = dbcDisplay.func_74779_i("DBCHair");
            this.hairType = dbcDisplay.func_74779_i("DBCHairType");
            this.eyeType = dbcDisplay.func_74762_e("DBCEyeType");
            this.mouthType = dbcDisplay.func_74762_e("DBCMouthType");
            this.noseType = dbcDisplay.func_74762_e("DBCNoseType");
            this.bodyType = dbcDisplay.func_74762_e("DBCBodyType");
            this.tailState = dbcDisplay.func_74771_c("DBCTailState");
            this.hairColor = dbcDisplay.func_74762_e("DBCHairColor");
            this.eyeColor = dbcDisplay.func_74762_e("DBCEyeColor");
            this.bodyCM = dbcDisplay.func_74762_e("DBCBodyCM");
            this.bodyC1 = dbcDisplay.func_74762_e("DBCBodyC1");
            this.bodyC2 = dbcDisplay.func_74762_e("DBCBodyC2");
            this.bodyC3 = dbcDisplay.func_74762_e("DBCBodyC3");
            this.furColor = dbcDisplay.func_74762_e("DBCFurColor");
            this.arcoState = dbcDisplay.func_74762_e("DBCArcoState");
            this.hasArcoMask = dbcDisplay.func_74767_n("DBCArcoMask");
            this.hasFur = dbcDisplay.func_74767_n("DBCFur");
            this.hasEyebrows = !dbcDisplay.func_74764_b("DBCHasEyebrows") || dbcDisplay.func_74767_n("DBCHasEyebrows");
            this.auraID = dbcDisplay.func_74762_e("DBCAuraID");
            this.outlineID = dbcDisplay.func_74762_e("DBCOutlineID");
            this.rage = dbcDisplay.func_74762_e("DBCRage");
            this.isTransforming = dbcDisplay.func_74767_n("DBCIsTransforming");
            this.isKaioken = dbcDisplay.func_74767_n("DBCIsisKaioken");
            this.formID = dbcDisplay.func_74762_e("DBCFormID");
            this.selectedForm = dbcDisplay.func_74762_e("DBCSelectedForm");
            if (dbcDisplay.func_74764_b("kiWeaponLeft")) {
                this.kiWeaponLeft.readFromNBT(dbcDisplay, "kiWeaponLeft");
            }
            if (dbcDisplay.func_74764_b("kiWeaponRight")) {
                this.kiWeaponRight.readFromNBT(dbcDisplay, "kiWeaponRight");
            }
        } else {
            comp.func_82580_o("DBCDisplay");
        }
    }

    @Override
    public void setColor(String type, int color) {
        switch (type.toLowerCase()) {
            case "hair": {
                this.hairColor = color;
                break;
            }
            case "eye": {
                this.eyeColor = color;
                break;
            }
            case "bodycm": {
                this.bodyCM = color;
                break;
            }
            case "bodyc1": {
                this.bodyC1 = color;
                break;
            }
            case "bodyc2": {
                this.bodyC2 = color;
                break;
            }
            case "bodyc3": {
                this.bodyC3 = color;
                break;
            }
            case "fur": {
                this.furColor = color;
                break;
            }
            default: {
                throw new CustomNPCsException("Invalid type! Legal types: aura, hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
            }
        }
    }

    public boolean hasColor(String type) {
        Form form = this.getForm();
        boolean inF = form != null;
        switch (type.toLowerCase()) {
            case "hair": {
                return (inF ? form.display.bodyColors.hairColor : this.hairColor) != -1;
            }
            case "eye": {
                return (inF ? form.display.bodyColors.eyeColor : this.eyeColor) != -1;
            }
            case "bodycm": {
                return (inF ? form.display.bodyColors.bodyCM : this.bodyCM) != -1;
            }
            case "bodyc1": {
                return (inF ? form.display.bodyColors.bodyC1 : this.bodyC1) != -1;
            }
            case "bodyc2": {
                return (inF ? form.display.bodyColors.bodyC2 : this.bodyC2) != -1;
            }
            case "bodyc3": {
                return (inF ? form.display.bodyColors.bodyC3 : this.bodyC3) != -1;
            }
            case "fur": {
                return (inF ? form.display.bodyColors.furColor : this.furColor) != -1;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
    }

    @Override
    public int getColor(String type) {
        Form form = this.getForm();
        boolean inF = form != null;
        switch (type.toLowerCase()) {
            case "hair": {
                return inF ? form.display.bodyColors.hairColor : this.hairColor;
            }
            case "eye": {
                return inF ? form.display.bodyColors.eyeColor : this.eyeColor;
            }
            case "bodycm": {
                return inF ? form.display.bodyColors.bodyCM : this.bodyCM;
            }
            case "bodyc1": {
                return inF ? form.display.bodyColors.bodyC1 : this.bodyC1;
            }
            case "bodyc2": {
                return inF ? form.display.bodyColors.bodyC2 : this.bodyC2;
            }
            case "bodyc3": {
                return inF ? form.display.bodyColors.bodyC3 : this.bodyC3;
            }
            case "fur": {
                return inF ? form.display.bodyColors.furColor : this.furColor;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
    }

    public int getCurrentArcoState() {
        int state = this.arcoState;
        Form form = this.getForm();
        if (form != null) {
            switch (form.display.bodyType) {
                case "firstform": {
                    state = 0;
                    break;
                }
                case "secondform": {
                    state = 2;
                    break;
                }
                case "thirdform": {
                    state = 3;
                    break;
                }
                case "finalform": {
                    state = 4;
                    break;
                }
                case "ultimatecooler": {
                    state = 5;
                    break;
                }
                case "golden": {
                    state = 6;
                }
            }
        }
        return state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getHairCode() {
        return this.hairCode;
    }

    @Override
    public void setHairCode(String hairCode) {
        this.hairCode = hairCode;
    }

    @Override
    public IKiWeaponData getKiWeapon(int arm) {
        if (arm == 0) {
            return this.kiWeaponRight;
        }
        if (arm == 1) {
            return this.kiWeaponLeft;
        }
        return null;
    }

    @Override
    public byte getRace() {
        return this.race;
    }

    @Override
    public void setRace(byte race) {
        this.race = ValueUtil.clamp((byte)race, (byte)0, (byte)5);
    }

    @Override
    public int getBodyType() {
        return this.bodyType;
    }

    @Override
    public void setBodyType(int bodyType) {
        this.bodyType = ValueUtil.clamp((int)bodyType, (int)0, (int)2);
    }

    @Override
    public byte getTailState() {
        return this.tailState;
    }

    @Override
    public void setTailState(byte tail) {
        this.tailState = ValueUtil.clamp((byte)tail, (byte)0, (byte)2);
    }

    @Override
    public void setHairType(String type) {
        String s = type.toLowerCase();
        if (!(s.equals("base") || s.equals("ssj") || s.equals("ssj2") || s.equals("ssj3") || s.equals("ssj4") || s.equals("oozaru") || s.equals("raditz") || s.equals(""))) {
            throw new CustomNPCsException("Invalid type! Legal types: base, raditz, ssj, ssj2, ssj3, ssj4, oozaru", new Object[0]);
        }
        this.hairType = s;
    }

    @Override
    public String getHairType() {
        return this.hairType;
    }

    @Override
    public boolean hasCoolerMask() {
        return this.hasArcoMask;
    }

    @Override
    public void setHasCoolerMask(boolean has) {
        this.hasArcoMask = has;
    }

    @Override
    public boolean hasEyebrows() {
        return this.hasEyebrows;
    }

    @Override
    public void setHasEyebrows(boolean has) {
        this.hasEyebrows = has;
    }

    @Override
    public boolean hasBodyFur() {
        return this.hasFur;
    }

    @Override
    public void setHasBodyFur(boolean hasFur) {
        this.hasFur = hasFur;
    }

    @Override
    public boolean hasAura() {
        boolean has = AuraController.getInstance().has(this.auraID);
        if (!has && this.auraID > -1) {
            this.auraID = -1;
        }
        return has;
    }

    @Override
    public IAura getAura() {
        return AuraController.getInstance().get(this.auraID);
    }

    @Override
    public void setAura(IAura aura) {
        if (aura == null) {
            this.auraID = -1;
        } else {
            this.setAura(aura.getID());
        }
    }

    @Override
    public void setAura(int auraID) {
        this.auraID = AuraController.Instance.has(auraID) ? auraID : -1;
    }

    @Override
    public boolean isAuraToggled() {
        return this.auraOn;
    }

    @Override
    public void toggleAura(boolean toggle) {
        this.auraOn = toggle;
    }

    @Override
    public boolean isInAura(IAura aura) {
        return aura.getID() == this.auraID;
    }

    @Override
    public boolean isAuraOn() {
        return this.auraOn || this.isTransforming;
    }

    @Override
    public boolean isFusionSpectator() {
        return false;
    }

    @Override
    public void useStencilBuffer(boolean use) {
        this.useStencilBuffer = use;
    }

    @Override
    public HashMap getDBCAuras(boolean secondary) {
        if (!secondary) {
            return this.dbcAuraQueue;
        }
        return this.dbcSecondaryAuraQueue;
    }

    public Aura getToggledAura() {
        if (!this.auraOn && !this.isTransforming) {
            return null;
        }
        return this.getAur();
    }

    public Aura getAur() {
        if (this.isInForm()) {
            Form form = this.getForm();
            if (form.display.hasAura()) {
                return form.display.getAur();
            }
        }
        return (Aura)AuraController.getInstance().get(this.auraID);
    }

    @Override
    public void transform(int id) {
        if (!FormController.Instance.has(id)) {
            throw new CustomNPCsException("Form " + id + " does not exist!", new Object[0]);
        }
        this.isTransforming = true;
        this.selectedForm = id;
    }

    @Override
    public void transform(IForm form) {
        this.transform(form.getID());
    }

    @Override
    public void cancelTransformation() {
        this.selectedForm = -1;
        this.isTransforming = false;
    }

    @Override
    public void descend(int id) {
        TransformController.npcDescend(this.npc, id);
    }

    @Override
    public void descend(IForm form) {
        TransformController.npcDescend(this.npc, form == null ? -1 : form.getID());
    }

    @Override
    public IOutline getOutline() {
        IAura formAura;
        Aura aura = this.getToggledAura();
        OutlineController OC = OutlineController.getInstance();
        if (aura != null && OC.has(aura.display.outlineID)) {
            return (Outline)OC.get(aura.display.outlineID);
        }
        Form form = this.getForm();
        if (form != null && OC.has(form.display.outlineID)) {
            return (Outline)OC.get(form.display.outlineID);
        }
        IAura iAura = formAura = form != null ? form.display.getAura() : null;
        if (formAura != null) {
            aura = (Aura)formAura;
            if (aura.display.outlineAlwaysOn && OC.has(aura.display.outlineID)) {
                return (Outline)OC.get(aura.display.outlineID);
            }
        }
        if ((aura = (Aura)AuraController.Instance.get(this.auraID)) != null && aura.display.outlineAlwaysOn && OC.has(aura.display.outlineID)) {
            return (Outline)OC.get(aura.display.outlineID);
        }
        return OutlineController.getInstance().get(this.outlineID);
    }

    @Override
    public void setOutline(int id) {
        this.outlineID = OutlineController.Instance.has(id) ? id : -1;
    }

    @Override
    public void setOutline(IOutline outline) {
        int id = outline != null ? outline.getID() : -1;
        this.setOutline(id);
    }

    public Form getForm() {
        if (this.formID == -100 && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (fakeForm == null) {
                fakeForm = new Form(-100, "EXTREME_FAKE_FORM");
            }
            return fakeForm;
        }
        if (this.formID > 0) {
            return (Form)FormController.Instance.get(this.formID);
        }
        return null;
    }

    @Override
    public void setForm(int id) {
        Form f = (Form)FormController.Instance.get(id);
        if (f != null) {
            this.formID = f.id;
        }
    }

    @Override
    public void setForm(IForm form) {
        int id = form != null ? form.getID() : -1;
        this.setForm(id);
    }

    public boolean isInForm() {
        return this.formID > -1 && this.getForm() != null;
    }

    @Override
    public IForm getCurrentForm() {
        return this.getForm();
    }

    @Override
    public boolean isInForm(IForm form) {
        return this.formID == form.getID();
    }

    @Override
    public void setFormLevel(float amount) {
        this.formLevel = amount;
    }

    @Override
    public float getFormLevel(int formID) {
        if (formID != -1) {
            return this.formLevel;
        }
        return 0.0f;
    }

    public void setDefaultColors() {
        this.eyeColor = 0;
        if (this.race < 3) {
            this.bodyCM = 16297621;
            this.bodyC1 = 6498048;
            this.bodyC2 = -1;
            this.bodyC3 = -1;
            this.furColor = -1;
        } else if (this.race == 3) {
            this.hairColor = 5095183;
            this.bodyCM = 5095183;
            this.bodyC1 = 13796998;
            this.bodyC2 = 12854822;
            this.bodyC3 = -1;
        } else if (this.race == 4) {
            this.eyeColor = 0xFF0000;
            this.bodyCM = 15460342;
            this.bodyC1 = 16111595;
            this.bodyC2 = 8533141;
            this.bodyC3 = 16550015;
        } else if (this.race == 5) {
            this.eyeColor = 0xFF0000;
            this.bodyCM = 16757199;
            this.bodyC1 = -1;
            this.bodyC2 = -1;
            this.bodyC3 = -1;
        }
    }

    public void clearHairCode(boolean forceDefaultHair) {
        boolean useDefaultHair;
        this.hairColor = 0;
        boolean bl = useDefaultHair = forceDefaultHair || this.hairCode == null || this.hairCode.isEmpty();
        if (this.race < 3) {
            this.hairCode = useDefaultHair ? "025050545050210250505450501801505045505021025050475050180147507467503248505072675043255250726750360150505667501922475071675038255050716750380152507167503202475071675032025250716750300050507167503000505047655036205250276550362250502765503620475027655036225250306550363150503065503622475030655034015250276550250147502765503000505027655036175050505050803150505050508028505050505080225050505050801750505050508022505050505080255050505050801750505050508000505050505080005050505050800050505050508000505050505080005050505050800050505050508000505050505080005050505050803154508067504931545080615028285450766150472854506561506551525080675038655250806150786052507861503451525069615050625050806950528250508061503485505078615030625050696150585149508069506157495080615080624950786150805149506961504920" : "";
        } else if (this.race < 5) {
            this.hairCode = "";
        } else if (this.race == 5) {
            this.hairCode = useDefaultHair ? "005050555050000050505550500000505055505000005050455050000050505250500000505052505000005050555050000050505450500000505052505000005050525050000150433450500000505055505000005050525050000054395050500000505045505000005050475050000050504750500000505047505000015043655050000050504750500000505047505000005050475050000050504750500000544545505000005250505050000052505050500000525050505000005250505050000050505050500000505050505000005050505050000052505050500000525050505000005250505050000052505050500000525050505000005245505050000054505050500000525050505000005252505050000070505050500000705050505000007050505050000070505050500000705050505000347050505050003470505050500000705050505000007050505050000069505050500000695050505000007050505050000070505050500000705050505000007050505050000070505050500020" : "";
            this.hairColor = this.bodyCM;
        }
        this.hairType = "base";
    }

    public void setDefaultHair() {
        this.clearHairCode(true);
    }

    @Override
    public EntityAura getAuraEntity() {
        return this.auraEntity;
    }

    @Override
    public void setAuraEntity(EntityAura aura) {
        this.auraEntity = aura;
    }

    @Override
    public Entity getEntity() {
        return this.npc;
    }

    @Override
    public int getAuraColor() {
        return 0xA8FFFF;
    }

    @Override
    public int getActiveAuraColor() {
        return this.activeAuraColor;
    }

    @Override
    public void setActiveAuraColor(int color) {
        this.activeAuraColor = color;
    }

    @Override
    public boolean isTransforming() {
        return this.isTransforming;
    }

    @Override
    public boolean isChargingKi() {
        return this.auraOn;
    }

    @Override
    public boolean isInKaioken() {
        return this.isKaioken;
    }

    @Override
    public int getFormID() {
        return this.formID;
    }

    @Override
    public byte getRelease() {
        return ((INPCStats)this.npc.stats).getDBCStats().release;
    }

    @Override
    public byte getState() {
        return 0;
    }

    @Override
    public byte getState2() {
        return 0;
    }

    @Override
    public boolean isForm(int form) {
        return false;
    }

    @Override
    public int getDBCColor() {
        return this.getAuraColor();
    }

    @Override
    public List<EntityCusPar> getParticles() {
        return this.particleRenderQueue;
    }

    public void setRacialExtras() {
        ModelData data = ((EntityCustomNpc)this.npc).modelData;
        data.removePart("dbcHorn");
        data.removePart("tail");
        data.removePart("dbcArms");
        data.removePart("dbcBody");
        data.removePart("dbcEars");
        if (!this.enabled || !this.useSkin) {
            return;
        }
        if (DBCRace.isSaiyan(this.race)) {
            ModelPartData tail = data.getOrCreatePart("tail");
            tail.setTexture("tail/monkey1", 8);
            tail.pattern = this.tailState < 2 ? this.tailState : (byte)0;
        } else if (this.race == 4) {
            ModelPartData tail = data.getOrCreatePart("tail");
            tail.setTexture("tail/monkey1", 8);
            tail.pattern = (byte)2;
            ModelPartData ears = data.getOrCreatePart("dbcEars");
            ears.setTexture("tail/monkey1", 1);
            ModelPartData horn = data.getOrCreatePart("dbcHorn");
            int arcoState = this.getArco();
            switch (arcoState) {
                case 0: 
                case 1: {
                    horn.setTexture("tail/monkey1", 2);
                    break;
                }
                case 2: {
                    horn.setTexture("tail/monkey1", 3);
                    break;
                }
                case 3: {
                    horn.setTexture("tail/monkey1", 4);
                    ModelPartData arms = data.getOrCreatePart("dbcArms");
                    arms.setTexture("tail/monkey1", 2);
                    break;
                }
                case 4: {
                    data.removePart("dbcHorn");
                    break;
                }
                case 5: {
                    horn.setTexture("tail/monkey1", 5);
                    ModelPartData arms = data.getOrCreatePart("dbcArms");
                    arms.setTexture("tail/monkey1", 1);
                    ModelPartData body = data.getOrCreatePart("dbcBody");
                    body.setTexture("tail/monkey1", 1);
                    break;
                }
                default: {
                    data.removePart("dbcHorn");
                    break;
                }
            }
        } else if (this.race == 3) {
            ModelPartData horn = data.getOrCreatePart("dbcHorn");
            horn.setTexture("tail/monkey1", 1);
        }
    }

    public int getArco() {
        int arcoState = this.arcoState;
        Form form = this.getForm();
        if (form != null) {
            if (form.display.bodyType.equals("firstform")) {
                arcoState = 0;
            } else if (form.display.bodyType.equals("secondform")) {
                arcoState = 2;
            } else if (form.display.bodyType.equals("thirdform")) {
                arcoState = 3;
            } else if (form.display.bodyType.equals("finalform")) {
                arcoState = 4;
            } else if (form.display.bodyType.equals("ultimatecooler")) {
                arcoState = 5;
            } else if (form.display.bodyType.equals("golden")) {
                arcoState = 6;
            }
        }
        return arcoState;
    }

    public IDBCDisplay clone() {
        DBCDisplay aura = new DBCDisplay(null);
        aura.readFromNBT(this.writeToNBT(new NBTTagCompound()));
        return aura;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityCustomNpc setupGUINPC(EntityCustomNpc originalNPC) {
        DBCDisplay origDisplay = null;
        EntityCustomNpc npc = new EntityCustomNpc((World)Minecraft.func_71410_x().field_71441_e);
        if (originalNPC != null) {
            origDisplay = ((INPCDisplay)originalNPC.display).getDBCDisplay();
        }
        DBCDisplay visualDisplay = ((INPCDisplay)npc.display).getDBCDisplay();
        if (origDisplay != null && origDisplay.enabled && origDisplay.useSkin) {
            visualDisplay.readFromNBT(origDisplay.writeToNBT(new NBTTagCompound()));
            if (DBCRace.isSaiyan(visualDisplay.race)) {
                visualDisplay.tailState = 1;
            }
            visualDisplay.setRacialExtras();
        } else {
            visualDisplay.enabled = true;
            visualDisplay.useSkin = true;
            visualDisplay.race = DBCData.getClient().Race;
            visualDisplay.setDefaultColors();
            boolean isSaiyan = DBCRace.isSaiyan(visualDisplay.race);
            if (isSaiyan) {
                visualDisplay.tailState = 1;
            }
            if (visualDisplay.race == 4 || visualDisplay.race == 3) {
                visualDisplay.hairCode = "";
            } else if (visualDisplay.race == 5) {
                visualDisplay.hairCode = "005050555050000050505550500000505055505000005050455050000050505250500000505052505000005050555050000050505450500000505052505000005050525050000150433450500000505055505000005050525050000054395050500000505045505000005050475050000050504750500000505047505000015043655050000050504750500000505047505000005050475050000050504750500000544545505000005250505050000052505050500000525050505000005250505050000050505050500000505050505000005050505050000052505050500000525050505000005250505050000052505050500000525050505000005245505050000054505050500000525050505000005252505050000070505050500000705050505000007050505050000070505050500000705050505000347050505050003470505050500000705050505000007050505050000069505050500000695050505000007050505050000070505050500000705050505000007050505050000070505050500020";
                visualDisplay.hairColor = visualDisplay.bodyCM;
            }
            visualDisplay.setRacialExtras();
        }
        return npc;
    }
}

