/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.form.IFormKaiokenStackables;
import kamkeel.npcdbc.api.form.IFormStackable;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormKaiokenStackableData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FormStackable
implements IFormStackable {
    private final Form parent;
    public boolean vanillaStackable = false;
    public boolean kaiokenStackable = true;
    public boolean uiStackable = true;
    public boolean godStackable = true;
    public boolean mysticStackable = true;
    public float uiStrength = 1.0f;
    public float godStrength = 1.0f;
    public float mysticStrength = 1.0f;
    public float legendaryStrength = 1.0f;
    public float divineStrength = 1.0f;
    public float majinStrength = 1.0f;
    public float uiState2Factor = 1.0f;
    public boolean useLegendaryConfig;
    public boolean useDivineConfig;
    public boolean useMajinConfig;
    public int legendaryID = -1;
    public int divineID = -1;
    public int majinID = -1;
    public int fusionID = -1;
    public FormKaiokenStackableData kaiokenData;

    public FormStackable(Form parent) {
        this.parent = parent;
        this.kaiokenData = new FormKaiokenStackableData(parent, this);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound stack = compound.func_74775_l("stackableForms");
        this.vanillaStackable = stack.func_74767_n("vanillaStackable");
        this.kaiokenStackable = stack.func_74767_n("kaiokenStackable");
        this.uiStrength = stack.func_74760_g("uiStrength");
        this.uiStackable = stack.func_74767_n("uiStackable");
        this.uiState2Factor = stack.func_74760_g("uiState2Factor");
        this.godStrength = stack.func_74760_g("godStrength");
        this.godStackable = stack.func_74767_n("godStackable");
        this.mysticStrength = stack.func_74760_g("mysticStrength");
        this.mysticStackable = stack.func_74767_n("mysticStackable");
        this.legendaryStrength = !stack.func_74764_b("legendaryStrength") ? 1.0f : stack.func_74760_g("legendaryStrength");
        this.divineStrength = !stack.func_74764_b("divineStrength") ? 1.0f : stack.func_74760_g("divineStrength");
        this.majinStrength = !stack.func_74764_b("majinStrength") ? 1.0f : stack.func_74760_g("majinStrength");
        this.useLegendaryConfig = !stack.func_74764_b("useLegendaryConfig") ? true : stack.func_74767_n("useLegendaryConfig");
        this.useDivineConfig = !stack.func_74764_b("useDivineConfig") ? true : stack.func_74767_n("useDivineConfig");
        this.useMajinConfig = !stack.func_74764_b("useMajinConfig") ? true : stack.func_74767_n("useMajinConfig");
        this.legendaryID = !stack.func_74764_b("legendaryID") ? -1 : stack.func_74762_e("legendaryID");
        this.divineID = !stack.func_74764_b("divineID") ? -1 : stack.func_74762_e("divineID");
        this.majinID = !stack.func_74764_b("majinID") ? -1 : stack.func_74762_e("majinID");
        this.fusionID = !stack.func_74764_b("fusionID") ? -1 : stack.func_74762_e("fusionID");
        this.kaiokenData.readFromNBT(stack);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound stack = new NBTTagCompound();
        stack.func_74757_a("vanillaStackable", this.vanillaStackable);
        stack.func_74757_a("kaiokenStackable", this.kaiokenStackable);
        stack.func_74776_a("uiStrength", this.uiStrength);
        stack.func_74757_a("uiStackable", this.uiStackable);
        stack.func_74776_a("uiState2Factor", this.uiState2Factor);
        stack.func_74776_a("godStrength", this.godStrength);
        stack.func_74757_a("godStackable", this.godStackable);
        stack.func_74776_a("mysticStrength", this.mysticStrength);
        stack.func_74757_a("mysticStackable", this.mysticStackable);
        stack.func_74776_a("legendaryStrength", this.legendaryStrength);
        stack.func_74776_a("divineStrength", this.divineStrength);
        stack.func_74776_a("majinStrength", this.majinStrength);
        stack.func_74757_a("useLegendaryConfig", this.useLegendaryConfig);
        stack.func_74757_a("useDivineConfig", this.useDivineConfig);
        stack.func_74757_a("useMajinConfig", this.useMajinConfig);
        stack.func_74768_a("legendaryID", this.legendaryID);
        stack.func_74768_a("divineID", this.divineID);
        stack.func_74768_a("majinID", this.majinID);
        stack.func_74768_a("fusionID", this.fusionID);
        this.kaiokenData.saveToNBT(stack);
        compound.func_74782_a("stackableForms", (NBTBase)stack);
        return compound;
    }

    @Override
    public void setFusionForm(IForm form) {
        if (form == null) {
            this.fusionID = -1;
            return;
        }
        int id = form.getID();
        if (form.getID() == this.fusionID) {
            return;
        }
        if (id > -1) {
            this.fusionID = id;
        }
    }

    @Override
    public int getFusionFormID() {
        return this.fusionID;
    }

    @Override
    public IForm getFusionForm() {
        return FormController.Instance.get(this.fusionID);
    }

    @Override
    public void setLegendaryForm(IForm form) {
        if (form == null) {
            this.legendaryID = -1;
            return;
        }
        int id = form.getID();
        if (form.getID() == this.legendaryID) {
            return;
        }
        if (id > -1) {
            this.legendaryID = id;
        }
    }

    @Override
    public int getLegendaryFormID() {
        return this.legendaryID;
    }

    @Override
    public IForm getLegendaryForm() {
        return FormController.Instance.get(this.legendaryID);
    }

    @Override
    public void setDivineForm(IForm form) {
        if (form == null) {
            this.divineID = -1;
            return;
        }
        int id = form.getID();
        if (form.getID() == this.divineID) {
            return;
        }
        if (id > -1) {
            this.divineID = id;
        }
    }

    @Override
    public int getDivineFormID() {
        return this.divineID;
    }

    @Override
    public IForm getDivineForm() {
        return FormController.Instance.get(this.divineID);
    }

    @Override
    public void setMajinForm(IForm form) {
        if (form == null) {
            this.majinID = -1;
            return;
        }
        int id = form.getID();
        if (form.getID() == this.majinID) {
            return;
        }
        if (id > -1) {
            this.majinID = id;
        }
    }

    @Override
    public int getMajinFormID() {
        return this.majinID;
    }

    @Override
    public IForm getMajinForm() {
        return FormController.Instance.get(this.majinID);
    }

    @Override
    public void useConfigMulti(int DBCNonRacialFormID, boolean useConfig) {
        switch (DBCNonRacialFormID) {
            case 25: {
                this.useLegendaryConfig = useConfig;
                break;
            }
            case 26: {
                this.useDivineConfig = useConfig;
                break;
            }
            case 27: {
                this.useMajinConfig = useConfig;
            }
        }
    }

    @Override
    public boolean useConfigMulti(int DBCNonRacialFormID) {
        switch (DBCNonRacialFormID) {
            case 25: {
                return this.useLegendaryConfig;
            }
            case 26: {
                return this.useDivineConfig;
            }
            case 27: {
                return this.useMajinConfig;
            }
        }
        return false;
    }

    @Override
    public boolean isFormStackable(int DBCNonRacialFormID) {
        switch (DBCNonRacialFormID) {
            case 31: {
                return this.kaiokenStackable;
            }
            case 41: {
                return this.uiStackable;
            }
            case 24: {
                return this.godStackable;
            }
            case 21: {
                return this.mysticStackable;
            }
        }
        return false;
    }

    @Override
    public boolean isVanillaStackable() {
        return this.vanillaStackable;
    }

    @Override
    public void setVanillaStackable(boolean vanillaStackable) {
        this.vanillaStackable = vanillaStackable;
    }

    @Override
    public void allowStackForm(int DBCNonRacialFormID, boolean stackForm) {
        switch (DBCNonRacialFormID) {
            case 31: {
                this.kaiokenStackable = stackForm;
                break;
            }
            case 41: {
                this.uiStackable = stackForm;
                break;
            }
            case 24: {
                this.godStackable = stackForm;
                break;
            }
            case 21: {
                this.mysticStackable = stackForm;
            }
        }
    }

    @Override
    public IFormKaiokenStackables getKaiokenConfigs() {
        return this.kaiokenData;
    }

    @Override
    public void setFormMulti(int dbcForm, float multi) {
        switch (dbcForm) {
            case 41: {
                this.uiStrength = multi;
                break;
            }
            case 24: {
                this.godStrength = multi;
                break;
            }
            case 21: {
                this.mysticStrength = multi;
                break;
            }
            case 25: {
                this.legendaryStrength = multi;
                break;
            }
            case 26: {
                this.divineStrength = multi;
                break;
            }
            case 27: {
                this.majinStrength = multi;
            }
        }
    }

    @Override
    public float getFormMulti(int dbcForm) {
        switch (dbcForm) {
            case 41: {
                return this.uiStrength;
            }
            case 24: {
                return this.godStrength;
            }
            case 21: {
                return this.mysticStrength;
            }
            case 25: {
                return this.legendaryStrength;
            }
            case 26: {
                return this.divineStrength;
            }
            case 27: {
                return this.majinStrength;
            }
        }
        return 1.0f;
    }

    @Override
    public void setState2Factor(int dbcForm, float factor) {
        switch (dbcForm) {
            case 41: {
                this.uiState2Factor = factor;
            }
        }
    }

    @Override
    public float getState2Factor(int dbcForm) {
        switch (dbcForm) {
            case 41: {
                return this.uiState2Factor;
            }
        }
        return 1.0f;
    }

    @Override
    public FormStackable save() {
        if (this.parent != null) {
            this.parent.save();
        }
        return this;
    }
}

