/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import java.util.HashMap;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.form.IFormAdvanced;
import kamkeel.npcdbc.api.form.IFormDisplay;
import kamkeel.npcdbc.api.form.IFormMastery;
import kamkeel.npcdbc.api.form.IFormStackable;
import kamkeel.npcdbc.config.ConfigDBCGeneral;
import kamkeel.npcdbc.constants.DBCRace;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.FormAdvanced;
import kamkeel.npcdbc.data.form.FormAttributes;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.data.form.FormMagicData;
import kamkeel.npcdbc.data.form.FormMastery;
import kamkeel.npcdbc.data.form.FormStackable;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.NBTTags;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.scripted.NpcAPI;

public class Form
implements IForm {
    public int id = -1;
    public String name = "";
    public String menuName = "\u00a7aNEW";
    private int race = -1;
    public int timer = -1;
    public FormMastery mastery = new FormMastery(this);
    public FormDisplay display = new FormDisplay(this);
    public FormStackable stackable = new FormStackable(this);
    public FormAdvanced advanced = new FormAdvanced(this);
    public FormAttributes customAttributes = new FormAttributes(this);
    public FormMagicData magicData = new FormMagicData(this);
    public HashMap<Integer, Byte> requiredForm = new HashMap();
    public int childID = -1;
    public int parentID = -1;
    public boolean fromParentOnly = true;
    public float strengthMulti = 1.0f;
    public float dexMulti = 1.0f;
    public float willMulti = 1.0f;
    public int mindRequirement = 0;
    public String ascendSound = "jinryuudragonbc:1610.sss";
    public String descendSound = "npcdbc:transformationSounds.GodDescend";

    public Form() {
    }

    public Form(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("ID")) {
            this.id = compound.func_74762_e("ID");
        } else if (AnimationController.Instance != null) {
            this.id = FormController.Instance.getUnusedId();
        }
        this.name = compound.func_74779_i("name");
        this.menuName = compound.func_74779_i("menuName");
        this.race = compound.func_74762_e("race");
        this.timer = compound.func_74762_e("timer");
        this.childID = compound.func_74762_e("childID");
        this.parentID = compound.func_74762_e("parentID");
        this.fromParentOnly = compound.func_74767_n("fromParentOnly");
        this.requiredForm = NBTTags.getIntegerByteMap((NBTTagList)compound.func_150295_c("requiredForm", 10));
        this.mindRequirement = compound.func_74762_e("mindRequirement");
        NBTTagCompound attributes = compound.func_74775_l("attributes");
        this.strengthMulti = attributes.func_74760_g("strMulti");
        this.dexMulti = attributes.func_74760_g("dexMulti");
        this.willMulti = attributes.func_74760_g("willMulti");
        NBTTagCompound sounds = compound.func_74775_l("sounds");
        this.ascendSound = sounds.func_74779_i("ascendSound");
        this.descendSound = sounds.func_74779_i("descendSound");
        this.mastery.readFromNBT(compound);
        this.display.readFromNBT(compound);
        this.stackable.readFromNBT(compound);
        this.advanced.readFromNBT(compound);
        this.customAttributes.readFromNBT(compound);
        this.magicData.readFromNBT(compound);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("menuName", this.menuName);
        compound.func_74768_a("race", this.race);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("childID", this.childID);
        compound.func_74768_a("parentID", this.parentID);
        compound.func_74757_a("fromParentOnly", this.fromParentOnly);
        compound.func_74768_a("mindRequirement", this.mindRequirement);
        compound.func_74782_a("requiredForm", (NBTBase)NBTTags.nbtIntegerByteMap(this.requiredForm));
        NBTTagCompound attributes = new NBTTagCompound();
        attributes.func_74776_a("strMulti", this.strengthMulti);
        attributes.func_74776_a("dexMulti", this.dexMulti);
        attributes.func_74776_a("willMulti", this.willMulti);
        compound.func_74782_a("attributes", (NBTBase)attributes);
        NBTTagCompound sounds = new NBTTagCompound();
        sounds.func_74778_a("ascendSound", this.ascendSound);
        sounds.func_74778_a("descendSound", this.descendSound);
        compound.func_74782_a("sounds", (NBTBase)sounds);
        this.mastery.writeToNBT(compound);
        this.display.writeToNBT(compound);
        this.stackable.writeToNBT(compound);
        this.advanced.writeToNBT(compound);
        this.customAttributes.writeToNBT(compound);
        this.magicData.writeToNBT(compound);
        return compound;
    }

    @Override
    public float[] getAllMulti() {
        return new float[]{this.strengthMulti, this.dexMulti, this.willMulti};
    }

    @Override
    public void setAllMulti(float allMulti) {
        this.strengthMulti = allMulti;
        this.dexMulti = allMulti;
        this.willMulti = allMulti;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMenuName() {
        return this.menuName;
    }

    @Override
    public void setMenuName(String name) {
        if (name.contains("&")) {
            name = name.replace("&", "\u00a7");
        }
        this.menuName = name;
    }

    public int race() {
        if (this.race == 12) {
            return 1;
        }
        return this.race;
    }

    @Override
    public int getRace() {
        return this.race;
    }

    @Override
    public void setRace(int race) {
        if ((race > 5 || race < -1) && race != 12) {
            return;
        }
        this.race = race;
    }

    @Override
    public boolean raceEligible(IPlayer player) {
        return this.raceEligible((EntityPlayer)player.getMCEntity());
    }

    public boolean raceEligible(EntityPlayer player) {
        return this.raceEligible(DBCData.get((EntityPlayer)player).Race);
    }

    @Override
    public boolean raceEligible(int race) {
        if (this.race == 12) {
            return DBCRace.isSaiyan(race);
        }
        return this.race == -1 || this.race == race;
    }

    @Override
    public void setAttributeMulti(int id, float multi) {
        switch (id) {
            case 0: {
                this.strengthMulti = multi;
                break;
            }
            case 1: {
                this.dexMulti = multi;
                break;
            }
            case 3: {
                this.willMulti = multi;
            }
        }
    }

    @Override
    public float getAttributeMulti(int id) {
        switch (id) {
            case 0: {
                return this.strengthMulti;
            }
            case 1: {
                return this.dexMulti;
            }
            case 3: {
                return this.willMulti;
            }
        }
        return 1.0f;
    }

    @Override
    public void assignToPlayer(IPlayer player) {
        if (this.raceEligible(player)) {
            PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo((EntityPlayer)player.getMCEntity());
            formData.addForm(this);
            formData.updateClient();
        }
    }

    @Override
    public void assignToPlayer(String playerName) {
        this.assignToPlayer(NpcAPI.Instance().getPlayer(playerName));
    }

    @Override
    public void removeFromPlayer(IPlayer player) {
        this.removeFromPlayer(player, ConfigDBCGeneral.FORM_MASTERIES_CLEAR_ON_REMOVE);
    }

    @Override
    public void removeFromPlayer(String playerName) {
        this.removeFromPlayer(playerName, ConfigDBCGeneral.FORM_MASTERIES_CLEAR_ON_REMOVE);
    }

    @Override
    public void removeFromPlayer(IPlayer player, boolean removesMastery) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo((EntityPlayer)player.getMCEntity());
        formData.removeForm(this, removesMastery);
        if (formData.selectedForm == this.id) {
            formData.selectedForm = -1;
        }
        formData.updateClient();
    }

    @Override
    public void removeFromPlayer(String playerName, boolean removesMastery) {
        this.removeFromPlayer(NpcAPI.Instance().getPlayer(playerName), removesMastery);
    }

    @Override
    public String getAscendSound() {
        return this.ascendSound;
    }

    @Override
    public void setAscendSound(String directory) {
        this.ascendSound = directory;
    }

    @Override
    public String getDescendSound() {
        return this.descendSound;
    }

    @Override
    public void setDescendSound(String directory) {
        this.descendSound = directory;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int newID) {
        this.id = newID;
    }

    @Override
    public void linkChild(int formID) {
        if (formID == this.id) {
            return;
        }
        Form form = (Form)FormController.getInstance().get(formID);
        if (form != null) {
            this.childID = formID;
            form.parentID = this.id;
        }
    }

    @Override
    public void linkChild(IForm form) {
        this.linkChild(form.getID());
    }

    @Override
    public void linkParent(int formID) {
        if (formID == this.id) {
            return;
        }
        Form form = (Form)FormController.getInstance().get(formID);
        if (form != null) {
            this.parentID = formID;
            form.childID = this.id;
        }
    }

    @Override
    public void linkParent(IForm form) {
        this.linkParent(form.getID());
    }

    @Override
    public boolean isFromParentOnly() {
        return this.fromParentOnly;
    }

    @Override
    public void setFromParentOnly(boolean set) {
        this.fromParentOnly = set;
    }

    @Override
    public void addFormRequirement(int race, byte state) {
        if ((race > 5 || race < 0) && race != 12) {
            return;
        }
        this.requiredForm.put(race, state);
    }

    @Override
    public void removeFormRequirement(int race) {
        if ((race > 5 || race < 0) && race != 12) {
            return;
        }
        this.requiredForm.remove(race);
    }

    @Override
    public int getFormRequirement(int race) {
        if (!this.requiredForm.containsKey(race)) {
            return -1;
        }
        return this.requiredForm.get(race).byteValue();
    }

    @Override
    public boolean isChildOf(IForm parent) {
        while (parent.getChildID() != -1) {
            if (parent.getID() == this.id || parent.getChildID() == this.id) {
                return true;
            }
            parent = parent.getChild();
        }
        return false;
    }

    @Override
    public IForm getChild() {
        return FormController.Instance.get(this.childID);
    }

    @Override
    public int getChildID() {
        return this.childID;
    }

    @Override
    public boolean hasChild() {
        return this.childID != -1 && FormController.getInstance().has(this.childID);
    }

    @Override
    public void removeChildForm() {
        Form child;
        if (this.childID != -1 && (child = (Form)this.getChild()) != null) {
            child.parentID = -1;
        }
        this.childID = -1;
    }

    @Override
    public IForm getParent() {
        return FormController.Instance.get(this.parentID);
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    @Override
    public void setTimer(int timeInTicks) {
        this.timer = timeInTicks;
    }

    @Override
    public boolean hasTimer() {
        return this.timer > 0;
    }

    @Override
    public int getParentID() {
        return this.parentID;
    }

    @Override
    public boolean hasParent() {
        return this.parentID != -1 && FormController.getInstance().has(this.parentID);
    }

    @Override
    public void removeParentForm() {
        Form parent;
        if (this.parentID != -1 && (parent = (Form)this.getParent()) != null) {
            parent.childID = -1;
        }
        this.parentID = -1;
    }

    @Override
    public IFormMastery getMastery() {
        return this.mastery;
    }

    @Override
    public IFormDisplay getDisplay() {
        return this.display;
    }

    @Override
    public IFormStackable getStackable() {
        return this.stackable;
    }

    @Override
    public IFormAdvanced getAdvanced() {
        return this.advanced;
    }

    @Override
    public void setMindRequirement(int mind) {
        this.mindRequirement = Math.max(mind, 0);
    }

    @Override
    public int getMindRequirement() {
        return this.mindRequirement;
    }

    @Override
    public IForm clone() {
        Form form = new Form();
        form.readFromNBT(this.writeToNBT());
        form.id = FormController.Instance.getUnusedId();
        return form;
    }

    @Override
    public IForm save() {
        return FormController.Instance.saveForm(this);
    }
}

