/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data;

import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SoundSource {
    public String key;
    public String soundDir;
    public Entity entity;
    public float maxVolume = 1.0f;
    public float range = 16.0f;
    public boolean onlyOneCanExist = false;
    public boolean fadeOut = false;
    public boolean fadeIn = false;
    public float fadeFactor = 0.01f;

    public SoundSource(String soundDir) {
        this.soundDir = soundDir;
    }

    public SoundSource(String soundDir, Entity entity) {
        this.soundDir = soundDir;
        this.entity = entity;
        this.key = this.toString();
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74776_a("maxVolume", this.maxVolume);
        c.func_74776_a("range", this.range);
        c.func_74776_a("fadeFactor", this.fadeFactor);
        c.func_74757_a("repeat", false);
        c.func_74757_a("onlyOneCanExist", this.onlyOneCanExist);
        c.func_74757_a("fadeOut", this.fadeOut);
        c.func_74757_a("fadeIn", this.fadeIn);
        c.func_74778_a("soundDir", this.soundDir);
        c.func_74778_a("key", this.key);
        c.func_74768_a("dimensionID", this.entity.field_70170_p.field_73011_w.field_76574_g);
        c.func_74778_a("entity", Utility.getEntityID(this.entity));
        return c;
    }

    public static SoundSource createFromNBT(NBTTagCompound compound) {
        String directory = compound.func_74779_i("soundDir");
        SoundSource soundSource = new SoundSource(directory);
        soundSource.maxVolume = compound.func_74760_g("maxVolume");
        soundSource.soundDir = directory;
        soundSource.fadeOut = compound.func_74767_n("fadeOut");
        soundSource.fadeIn = compound.func_74767_n("fadeIn");
        soundSource.fadeFactor = compound.func_74760_g("fadeFactor");
        soundSource.range = compound.func_74760_g("range");
        soundSource.onlyOneCanExist = compound.func_74767_n("onlyOneCanExist");
        soundSource.key = compound.func_74779_i("key");
        int dimID = compound.func_74762_e("dimensionID");
        World world = Utility.getWorld(dimID);
        soundSource.entity = Utility.getEntityFromID(world, compound.func_74779_i("entity"));
        return soundSource;
    }

    public String toString() {
        return this.entity.func_145782_y() + ":" + this.soundDir;
    }
}

