/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kamkeel.npcdbc.api.effect.IBonusHandler;
import kamkeel.npcdbc.api.effect.IPlayerBonus;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.api.entity.IPlayer;

public class BonusController
implements IBonusHandler {
    public static BonusController Instance = new BonusController();
    public HashMap<UUID, Map<String, PlayerBonus>> playerBonus = new HashMap();

    public static BonusController getInstance() {
        return Instance;
    }

    public void load() {
        this.playerBonus.clear();
    }

    public float[] getCurrentBonuses(EntityPlayer player) {
        Map<Object, Object> currentBonus = new HashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            currentBonus = this.playerBonus.get(Utility.getUUID((Entity)player));
        }
        float[] bonuses = new float[5];
        for (PlayerBonus playerBonus : currentBonus.values()) {
            bonuses[0] = bonuses[0] + playerBonus.strength;
            bonuses[1] = bonuses[1] + playerBonus.dexterity;
            bonuses[2] = bonuses[2] + playerBonus.willpower;
            bonuses[3] = bonuses[3] + playerBonus.constituion;
            bonuses[4] = bonuses[4] + playerBonus.spirit;
        }
        return bonuses;
    }

    public Map<String, PlayerBonus> getPlayerBonus(EntityPlayer player) {
        UUID playerId = Utility.getUUID((Entity)player);
        if (!this.playerBonus.containsKey(playerId)) {
            this.playerBonus.put(playerId, new ConcurrentHashMap());
        }
        return this.playerBonus.get(Utility.getUUID((Entity)player));
    }

    public void giveBonus(EntityPlayer player, PlayerBonus bon) {
        if (bon == null) {
            return;
        }
        Map<Object, Object> currentBonus = new HashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            currentBonus = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            this.playerBonus.put(uuid, currentBonus);
        }
        currentBonus.put(bon.name, bon);
    }

    public void removeEffect(EntityPlayer player, String bonusName) {
        Map<String, PlayerBonus> current;
        if (bonusName == null) {
            return;
        }
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            current = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            current = new HashMap<String, PlayerBonus>();
            this.playerBonus.put(uuid, current);
        }
        current.remove(bonusName);
    }

    public boolean hasBonus(EntityPlayer player, String id) {
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            return this.playerBonus.get(uuid).containsKey(id);
        }
        return false;
    }

    public void applyBonus(EntityPlayer player, PlayerBonus bonus) {
        Map<String, PlayerBonus> currentBonus;
        if (player == null || bonus == null) {
            return;
        }
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            currentBonus = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            currentBonus = new HashMap<String, PlayerBonus>();
            this.playerBonus.put(uuid, currentBonus);
        }
        currentBonus.put(bonus.name, bonus);
    }

    public void applyBonus(EntityPlayer player, String name, byte type, float str, float dex, float wil) {
        Map<String, PlayerBonus> currentbonus;
        if (player == null || name.isEmpty()) {
            return;
        }
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            currentbonus = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            currentbonus = new HashMap<String, PlayerBonus>();
            this.playerBonus.put(uuid, currentbonus);
        }
        PlayerBonus bonus = new PlayerBonus(name, type, str, dex, wil);
        currentbonus.put(name, bonus);
    }

    public void removeBonus(EntityPlayer player, PlayerBonus bonus) {
        Map<String, PlayerBonus> current;
        if (player == null || bonus == null) {
            return;
        }
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            current = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            current = new HashMap<String, PlayerBonus>();
            this.playerBonus.put(uuid, current);
        }
        current.remove(bonus.name);
    }

    public void removeBonus(EntityPlayer player, String name) {
        Map<String, PlayerBonus> current;
        if (player == null || name.isEmpty()) {
            return;
        }
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerBonus.containsKey(uuid)) {
            current = this.playerBonus.get(Utility.getUUID((Entity)player));
        } else {
            current = new HashMap<String, PlayerBonus>();
            this.playerBonus.put(uuid, current);
        }
        current.remove(name);
    }

    @Override
    public void clearBonuses(IPlayer player) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.clearBonuses((Entity)player.getMCEntity());
    }

    public void clearBonuses(Entity player) {
        Map<String, PlayerBonus> effects = this.playerBonus.get(Utility.getUUID(player));
        if (effects != null) {
            effects.clear();
        }
    }

    @Override
    public IPlayerBonus createBonus(String name, float str, float dex, float wil) {
        return new PlayerBonus(name, 0, str, dex, wil);
    }

    @Override
    public IPlayerBonus createBonus(String name, float str, float dex, float wil, float con, float spi) {
        return new PlayerBonus(name, 1, str, dex, wil, con, spi);
    }

    @Override
    public IPlayerBonus createBonus(String name, int type, float str, float dex, float wil, float con, float spi) {
        return new PlayerBonus(name, (byte)type, str, dex, wil, con, spi);
    }

    @Override
    public boolean hasBonus(IPlayer player, String name) {
        if (player == null || player.getMCEntity() == null) {
            return false;
        }
        return this.hasBonus((EntityPlayer)player.getMCEntity(), name);
    }

    @Override
    public boolean hasBonus(IPlayer player, IPlayerBonus bonus) {
        return this.hasBonus(player, bonus.getName());
    }

    @Override
    public void applyBonus(IPlayer player, String name, float str, float dex, float wil) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.applyBonus((EntityPlayer)player.getMCEntity(), name, (byte)0, str, dex, wil);
    }

    @Override
    public void applyBonus(IPlayer player, IPlayerBonus bonus) {
        if (bonus == null) {
            return;
        }
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.applyBonus((EntityPlayer)player.getMCEntity(), (PlayerBonus)bonus);
    }

    @Override
    public void removeBonus(IPlayer player, String name) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.removeBonus((EntityPlayer)player.getMCEntity(), name);
    }

    @Override
    public void removeBonus(IPlayer player, IPlayerBonus bonus) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.removeBonus((EntityPlayer)player.getMCEntity(), bonus.getName());
    }
}

