/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.config;

import java.io.File;
import kamkeel.npcdbc.client.ClientProxy;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigDBCClient {
    public static Configuration config;
    public static final String GENERAL = "General";
    public static Property HideInfoMessageProperty;
    public static boolean HideInfoMessage;
    public static final String GUI = "Gui";
    public static boolean EnableDebugStatSheetSwitching;
    public static Property EnhancedGuiProperty;
    public static boolean EnhancedGui;
    public static Property DarkModeProperty;
    public static boolean DarkMode;
    public static Property AdvancedGuiModeProperty;
    public static boolean AdvancedGui;
    public static final String RENDERING = "Rendering";
    public static Property EnableHDTexturesProperty;
    public static boolean EnableHDTextures;
    public static Property RevampAuraProperty;
    public static boolean RevampAura;
    public static Property EnableOutlinesProperty;
    public static boolean EnableOutlines;
    public static Property EnableShadersProperty;
    public static boolean EnableShaders;
    public static Property EnableBloomProperty;
    public static boolean EnableBloom;
    public static Property FirstPerson3DAuraOpacityProperty;
    public static int FirstPerson3DAuraOpacity;
    public static Property AlternateSelectionWheelTextureProperty;
    public static boolean AlteranteSelectionWheelTexture;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            HideInfoMessageProperty = config.get(GENERAL, "Hide Info Messages", false, "Hides Change Form and other various transformation messages in game");
            HideInfoMessage = HideInfoMessageProperty.getBoolean(false);
            EnableDebugStatSheetSwitching = config.get(GUI, "Enable old stat sheet toggle", false, "DEBUG ONLY\nThis for finding inconsistencies between the GUIs, nothing else as the old GUI is deprecated due to: \n >Incomplete custom form support.\n >Lacks DBC-related fixes in the GUI (Ki protection, passive protection shenanigans, etc.)\n\nPlease refrain from using the old GUI, as the replacement aims to be completely backwards compatible.\nIn the case you found a bug with it, please report it.\n\nEnables toggling between old DBC GUI and Addon replacements. ").getBoolean(false);
            EnhancedGuiProperty = config.get(GUI, "Enable Enhanced Gui", true, "Uses DBC Addons GUI for Coloring and Manipulation\n\nINFO: If DebugStatSheet switching is off, you cannot use old DBC GUI");
            EnhancedGui = EnhancedGuiProperty.getBoolean(true);
            DarkModeProperty = config.get(GUI, "Dark Mode", true, "Uses Dark Mode GUI in Enhanced Menu");
            DarkMode = DarkModeProperty.getBoolean(true);
            AdvancedGuiModeProperty = config.get(GUI, "Advanced GUI", false, "Shows Advanced Status Effects and Calculations in Menu");
            AdvancedGui = AdvancedGuiModeProperty.getBoolean(false);
            AlternateSelectionWheelTextureProperty = config.get(GUI, "Use Alternate Wheel GUI Texture", false, "Uses alternate texture for Wheel GUIs");
            AlteranteSelectionWheelTexture = AlternateSelectionWheelTextureProperty.getBoolean(false);
            RevampAuraProperty = config.get(RENDERING, "Revamp Aura", false, "Renders with the new DBC Addon style of auras");
            RevampAura = RevampAuraProperty.getBoolean(false);
            EnableHDTexturesProperty = config.get(RENDERING, "Enable HD Textures", false, "Uses internal DBC Addon HD Textures");
            EnableHDTextures = EnableHDTexturesProperty.getBoolean(false);
            EnableOutlinesProperty = config.get(RENDERING, "Enable Outlines", true, "Enables outlines for players and NPCs");
            EnableOutlines = EnableOutlinesProperty.getBoolean(true);
            EnableShadersProperty = config.get(RENDERING, "Enable Shaders", true, "Enables the use of shaders when rendering");
            EnableShaders = EnableShadersProperty.getBoolean(true);
            EnableBloomProperty = config.get(RENDERING, "Enable Bloom", true, "Enables the bloom effect for player outlines and auras");
            EnableBloom = EnableBloomProperty.getBoolean(true);
            FirstPerson3DAuraOpacityProperty = config.get(RENDERING, "First person 3D Aura Opacity", 100, "The opacity of the first person 3D Aura.\nModifying this makes it so auras on other players render normally without blinding you\n(Min: 0, Max: 100)");
            FirstPerson3DAuraOpacity = Math.max(Math.min(100, FirstPerson3DAuraOpacityProperty.getInt(100)), 0);
        }
        catch (Exception e) {
            ClientProxy.LOGGER.error("Error loading client configuration: " + e.getMessage());
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        HideInfoMessage = false;
        EnableDebugStatSheetSwitching = false;
        EnhancedGui = true;
        DarkMode = true;
        AdvancedGui = false;
        EnableHDTextures = false;
        RevampAura = false;
        EnableOutlines = true;
        EnableShaders = true;
        EnableBloom = true;
        FirstPerson3DAuraOpacity = 100;
        AlteranteSelectionWheelTexture = true;
    }
}

