/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import JinRyuu.JRMCore.JRMCoreH;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.TransformController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.scripted.DBCAPI;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcs.command.CommandKamkeelBase;
import kamkeel.npcs.util.ColorUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class FormCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "form";
    }

    public String getDescription() {
        return "Form operations";
    }

    @CommandKamkeelBase.SubCommand(desc="Gives a form to a player by name", usage="<player> <form_name>")
    public void give(ICommandSender sender, String[] args) throws CommandException {
        FormCommand hi = this;
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Form form = (Form)DBCAPI.Instance().getForm(name);
        if (form == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown form: " + name));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasFormUnlocked(form.id)) {
                if (form.raceEligible(playerdata.player)) {
                    info.addForm(form);
                    info.updateClient();
                    ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7agiven to \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername));
                    if (sender != playerdata.player) {
                        ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7aForm \u00a77%s \u00a7aadded.", form.getName()));
                    }
                } else {
                    byte playerRace = DBCData.get((EntityPlayer)playerdata.player).Race;
                    ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's \u00a7crace \u00a7b(%s)\u00a7c is not eligible for \u00a77%s", playerdata.playername, JRMCoreH.Races[playerRace], form.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eunlocked!", playerdata.playername, form.getName()));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Gives a form to a player by numerical ID", usage="<player> <form_ID>")
    public void giveid(ICommandSender sender, String[] args) throws CommandException {
        FormCommand hi = this;
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Form form = (Form)DBCAPI.Instance().getFormHandler().get(id);
        if (form == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown form: " + id));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasFormUnlocked(form.id)) {
                if (form.raceEligible(playerdata.player)) {
                    info.addForm(form);
                    info.updateClient();
                    ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7agiven to \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername));
                    if (sender != playerdata.player) {
                        ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7aForm \u00a77%s \u00a7aadded.", form.getName()));
                    }
                } else {
                    byte playerRace = DBCData.get((EntityPlayer)playerdata.player).Race;
                    ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's \u00a7crace \u00a7b(%s)\u00a7c is not eligible for \u00a77%s", playerdata.playername, JRMCoreH.Races[playerRace], form.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eunlocked!", playerdata.playername, form.getName()));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a form from a player by name", usage="<player> <form_name>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Form form = (Form)DBCAPI.Instance().getForm(name);
        if (form == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown form: " + name));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (info.hasForm(form)) {
                if (info.selectedForm == form.id) {
                    info.selectedForm = -1;
                }
                if (info.currentForm == form.id) {
                    TransformController.handleFormDescend(playerdata.player, -10);
                    info.currentForm = -1;
                }
                info.removeForm(form);
                info.updateClient();
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername));
                if (sender != playerdata.player) {
                    ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7c Form \u00a77%s \u00a7cremoved.", form.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7enot found on \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername, form.id));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a form from a player by numerical ID", usage="<player> <form_ID>")
    public void removeid(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Form form = (Form)DBCAPI.Instance().getFormHandler().get(id);
        if (form == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown form: " + id));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (info.hasForm(form)) {
                if (info.selectedForm == form.id) {
                    info.selectedForm = -1;
                }
                if (info.currentForm == form.id) {
                    TransformController.handleFormDescend(playerdata.player, -10);
                    info.currentForm = -1;
                }
                info.removeForm(form);
                info.updateClient();
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername));
                if (sender != playerdata.player) {
                    ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7c Form \u00a77%s \u00a7cremoved.", form.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7enot found on \u00a77'\u00a7b%s\u00a77'", form.getName(), playerdata.playername, form.id));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Clears all forms from a player", usage="<player>")
    public void clear(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            info.clearAllForms();
            info.updateClient();
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("Removed all forms from '\u00a7b%s\u00a77'", playerdata.playername));
            if (sender != playerdata.player) {
                ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("All custom forms removed.", new Object[0]));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="List all forms on a player", usage="<player>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
            PlayerDBCInfo playerDBCInfo = PlayerDataUtil.getDBCInfo(playerdata);
            if (playerDBCInfo.unlockedForms.isEmpty()) {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("No Forms found for Player '\u00a7b%s\u00a77'", playerdata.playername));
            } else {
                for (int formID : playerDBCInfo.unlockedForms) {
                    IForm form = FormController.getInstance().get(formID);
                    if (form == null) continue;
                    ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s", form.getName()));
                }
            }
            ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists all existing forms")
    public void infoall(ICommandSender sender, String[] args) throws CommandException {
        ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
        for (Form form : FormController.getInstance().customForms.values()) {
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s \u00a77(ID: %d)", form.getName(), form.id));
        }
        ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
    }

    @CommandKamkeelBase.SubCommand(desc="Reloads all forms")
    public void reload(ICommandSender sender, String[] args) {
        FormController.Instance.load();
        ColorUtil.sendResult((ICommandSender)sender, (String)"Forms reloaded!");
    }

    @CommandKamkeelBase.SubCommand(desc="Find form id number by its name", usage="<formName>")
    public void id(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            ColorUtil.sendError((ICommandSender)sender, (String)"Please provide a name for the form");
            return;
        }
        String formName = String.join((CharSequence)" ", args).toLowerCase();
        Collection<Form> forms = FormController.getInstance().customForms.values();
        int count = 0;
        for (Form form : forms) {
            if (!form.getName().toLowerCase().contains(formName)) continue;
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("Form \u00a7e%d\u00a77 - \u00a7c'%s'", form.id, form.getName()));
            ++count;
        }
        if (count == 0) {
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("No Form found with name: \u00a7c'%s'", formName));
        }
    }
}

