/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kamkeel.npcdbc.CommonProxy;
import kamkeel.npcdbc.client.CNPCAnimationHelper;
import kamkeel.npcdbc.client.ClientConstants;
import kamkeel.npcdbc.client.ClientEventHandler;
import kamkeel.npcdbc.client.KeyHandler;
import kamkeel.npcdbc.client.render.AuraRenderer;
import kamkeel.npcdbc.client.render.PotaraItemRenderer;
import kamkeel.npcdbc.client.render.RenderEventHandler;
import kamkeel.npcdbc.client.shader.PostProcessing;
import kamkeel.npcdbc.client.shader.ShaderHelper;
import kamkeel.npcdbc.entity.EntityAura;
import kamkeel.npcdbc.items.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static int lastRendererGUIPlayerID = -1;

    public static void eventsInit() {
        FMLCommonHandler.instance().bus().register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new RenderEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    @Override
    public void preInit(FMLPreInitializationEvent ev) {
        super.preInit(ev);
        this.forceStencilEnable();
    }

    @Override
    public void init(FMLInitializationEvent ev) {
        super.init(ev);
        ClientProxy.eventsInit();
        KeyHandler.registerKeys();
        RenderingRegistry.registerEntityRenderingHandler(EntityAura.class, (Render)new AuraRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.Potaras, (IItemRenderer)new PotaraItemRenderer());
        ShaderHelper.loadShaders(false);
        ClientConstants.startTime = Instant.now();
    }

    @Override
    public void postInit(FMLPostInitializationEvent ev) {
        PostProcessing.init(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        Collection renderManager = RenderManager.field_78727_a.field_78729_o.values();
        for (Object o : renderManager) {
            if (!(o instanceof RendererLivingEntity)) continue;
            ModelBase mainModel = ((RendererLivingEntity)o).field_77045_g;
            CNPCAnimationHelper.setOriginalValues(mainModel);
        }
    }

    public static float getTimeSinceStart() {
        return (float)Duration.between(ClientConstants.startTime, Instant.now()).toMillis() / 1000.0f;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public int getNewRenderId() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    @Override
    public void registerItem(Item item) {
    }

    @Override
    public boolean isRenderingGUI() {
        return ClientConstants.renderingGUI;
    }

    public static boolean isRenderingWorld() {
        return ClientConstants.renderingWorld;
    }

    private void forceStencilEnable() {
        try {
            System.setProperty("forge.forceDisplayStencil", "true");
            Field field = ForgeHooksClient.class.getDeclaredField("stencilBits");
            field.setAccessible(true);
            field.setInt(ForgeHooksClient.class, 8);
        }
        catch (Exception e) {
            LOGGER.error("Failed setting stencil bits to 8: " + e.getMessage());
        }
    }
}

