/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.mixin.plugin;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public enum TargetedMod {
    VANILLA("Minecraft", "unused", true, new String[0]),
    BOTANIA("Botania", "botania", true, "botania"),
    CUSTOM_NPCS("CustomNPC", "CustomNPC", true, "customnpcs");

    public final String modName;
    public final String jarNamePrefixLowercase;
    public final boolean loadInDevelopment;
    public final String[] modId;

    private TargetedMod(String modName, String jarNamePrefix, boolean loadInDevelopment, String ... modId) {
        this.modName = modName;
        this.jarNamePrefixLowercase = jarNamePrefix.toLowerCase();
        this.loadInDevelopment = loadInDevelopment;
        this.modId = modId;
    }

    public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        String modIdString = null;
        if (this.modId != null) {
            try {
                modIdString = TargetedMod.getModID(path.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (nameLowerCase.startsWith(this.jarNamePrefixLowercase) || modIdString != null && Arrays.asList(this.modId).contains(modIdString)) && "jar".equals(fileExtension);
    }

    private static String getModID(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> zipEntryEnumeration = zipFile.entries();
            while (zipEntryEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = zipEntryEnumeration.nextElement();
                if (zipEntry == null || !zipEntry.getName().equalsIgnoreCase("mcmod.info")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String read;
                    while ((read = bufferedReader.readLine()) != null) {
                        if (!read.contains("\"modid\"")) continue;
                        String string = read.replaceAll("\"", "").replaceAll("modid", "").replaceAll(":", "").replaceAll(",", "").replaceAll("\t", "").replaceAll("\n", "").replaceAll(" ", "").replaceAll("\\{", "").replaceAll("}", "");
                        return string;
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return null;
    }

    public String toString() {
        return "TargetedMod{modName='" + this.modName + '\'' + ", jarNamePrefixLowercase='" + this.jarNamePrefixLowercase + '\'' + '}';
    }
}

