/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBar;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class BossBarPacket
implements IMessage {
    private BossBar component;
    private PacketType packetType = PacketType.ADD;

    public BossBarPacket() {
    }

    public BossBarPacket(NBTTagCompound tagCompound, PacketType type) {
        this.component = BossBar.createBossBar(tagCompound);
        this.packetType = type;
    }

    public BossBarPacket(BossBar bossBarComponent, PacketType type) {
        this.component = bossBarComponent;
        this.packetType = type;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.packetType = PacketType.valueOfString(tagCompound.func_74779_i("packetType"));
        this.component = BossBar.createBossBar(tagCompound);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = this.component.toNbt();
        tagCompound.func_74778_a("packetType", this.packetType.getName());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    public BossBar getComponent() {
        return this.component;
    }

    public PacketType getPacketType() {
        return this.packetType;
    }

    public static enum PacketType {
        ADD("add"),
        REMOVE("remove"),
        UPDATE("update");

        private final String name;

        private PacketType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PacketType valueOfString(String name) {
            for (PacketType type : PacketType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return ADD;
        }
    }
}

