/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import noppes.npcs.api.handler.IActionManager;
import noppes.npcs.api.handler.data.IAction;
import noppes.npcs.api.handler.data.IActionChain;
import noppes.npcs.api.handler.data.actions.IConditionalAction;
import noppes.npcs.controllers.data.action.Action;
import noppes.npcs.controllers.data.action.ActionChain;
import noppes.npcs.controllers.data.action.ConditionalAction;
import noppes.npcs.controllers.data.action.ParallelActionChain;

public class ScriptedActionManager
implements IActionManager {
    private boolean isWorking = false;
    private final Deque<IAction> actionQueue = new ConcurrentLinkedDeque<IAction>();
    private final Deque<IAction> parallelActions = new ConcurrentLinkedDeque<IAction>();
    private final Deque<IConditionalAction> conditionalActions = new ConcurrentLinkedDeque<IConditionalAction>();

    @Override
    public IAction create(String name) {
        return new Action(this, name);
    }

    @Override
    public IAction create(Consumer<IAction> t) {
        return new Action(this, t);
    }

    @Override
    public IAction create(String name, int maxDuration, int startAfterTicks, Consumer<IAction> task) {
        return new Action(this, name, maxDuration, startAfterTicks, task);
    }

    @Override
    public IAction create(String name, int delay, Consumer<IAction> t) {
        return new Action(this, name, delay, t);
    }

    @Override
    public IAction create(int delay, Consumer<IAction> t) {
        return new Action(this, delay, t);
    }

    @Override
    public IAction create(String name, Consumer<IAction> t) {
        return new Action(this, name, t);
    }

    @Override
    public IConditionalAction create(Supplier<Boolean> condition, Consumer<IAction> task) {
        return new ConditionalAction(this, condition, task);
    }

    @Override
    public IConditionalAction create(String name, Supplier<Boolean> condition, Consumer<IAction> task) {
        return new ConditionalAction(this, name, condition, task);
    }

    @Override
    public IConditionalAction create(Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        return new ConditionalAction(this, condition, task, terminateWhen);
    }

    @Override
    public IConditionalAction create(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        return new ConditionalAction(this, name, condition, task, terminateWhen);
    }

    @Override
    public IConditionalAction create(Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        return new ConditionalAction(this, condition, task, terminateWhen, onTermination);
    }

    @Override
    public IConditionalAction create(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        return new ConditionalAction(this, name, condition, task, terminateWhen, onTermination);
    }

    @Override
    public void start() {
        this.isWorking = true;
    }

    @Override
    public void stop() {
        this.isWorking = false;
    }

    @Override
    public IAction scheduleAction(IAction action) {
        this.actionQueue.addLast(action);
        return action;
    }

    @Override
    public IAction scheduleAction(String name, int maxDuration, int startAfterTicks, Consumer<IAction> task) {
        return this.scheduleAction(this.create(name, maxDuration, startAfterTicks, task));
    }

    @Override
    public IAction scheduleActionAt(int index, IAction action) {
        int size = this.actionQueue.size();
        if (index <= 0) {
            this.actionQueue.addFirst(action);
        } else if (index >= size) {
            this.actionQueue.addLast(action);
        } else {
            ArrayList<IAction> tmp = new ArrayList<IAction>(this.actionQueue);
            tmp.add(index, action);
            this.actionQueue.clear();
            this.actionQueue.addAll(tmp);
        }
        return action;
    }

    @Override
    public int getIndex(IAction action) {
        int i = 0;
        for (IAction a : this.actionQueue) {
            if (a.equals(action)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IAction getCurrentAction() {
        return this.actionQueue.peekFirst();
    }

    @Override
    public Queue<IAction> getActionQueue() {
        return this.actionQueue;
    }

    @Override
    public void clear() {
        this.actionQueue.clear();
        this.parallelActions.clear();
        this.conditionalActions.clear();
    }

    @Override
    public boolean cancelAction(String name) {
        Iterator<IAction> acts = this.actionQueue.iterator();
        while (acts.hasNext()) {
            IAction act = acts.next();
            if (!act.getName().equals(name)) continue;
            acts.remove();
            return true;
        }
        Iterator<IAction> pit = this.parallelActions.iterator();
        while (pit.hasNext()) {
            if (!pit.next().getName().equals(name)) continue;
            pit.remove();
            return true;
        }
        Iterator<IConditionalAction> cons = this.conditionalActions.iterator();
        while (cons.hasNext()) {
            IConditionalAction con = cons.next();
            if (!con.getName().equals(name)) continue;
            cons.remove();
            return true;
        }
        return false;
    }

    @Override
    public IConditionalAction scheduleAction(String name, Supplier<Boolean> condition, Consumer<IAction> task) {
        return this.scheduleAction(new ConditionalAction(this, name, condition, task));
    }

    @Override
    public IConditionalAction scheduleAction(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen) {
        return this.scheduleAction(new ConditionalAction(this, name, condition, task, terminateWhen));
    }

    @Override
    public IConditionalAction scheduleAction(String name, Supplier<Boolean> condition, Consumer<IAction> task, Supplier<Boolean> terminateWhen, Consumer<IAction> onTermination) {
        return this.scheduleAction(new ConditionalAction(this, name, condition, task, terminateWhen, onTermination));
    }

    @Override
    public IConditionalAction scheduleAction(IConditionalAction action) {
        this.conditionalActions.add(action);
        return action;
    }

    @Override
    public List<IConditionalAction> getConditionalActions() {
        return new ArrayList<IConditionalAction>(this.conditionalActions);
    }

    @Override
    public IAction scheduleParallelAction(IAction action) {
        this.parallelActions.add(action);
        return action;
    }

    public void tick(int ticksExisted) {
        if (!this.isWorking) {
            return;
        }
        IAction current = this.getCurrentAction();
        if (current instanceof Action) {
            Action cab = (Action)current;
            cab.tick(ticksExisted);
            if (cab.isDone()) {
                this.actionQueue.pollFirst();
            }
        }
        Iterator<IAction> pit = this.parallelActions.iterator();
        while (pit.hasNext()) {
            Action a = (Action)pit.next();
            a.tick(ticksExisted);
            if (!a.isDone()) continue;
            pit.remove();
        }
        Iterator<IConditionalAction> cit = this.conditionalActions.iterator();
        while (cit.hasNext()) {
            ConditionalAction con = (ConditionalAction)cit.next();
            con.tick(ticksExisted);
            if (!con.isDone()) continue;
            cit.remove();
        }
    }

    @Override
    public IActionChain chain() {
        return new ActionChain(this);
    }

    @Override
    public IActionChain parallelChain() {
        return new ParallelActionChain(this);
    }
}

