/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.handler.data.IAnvilRecipe;
import noppes.npcs.controllers.data.Availability;

public class RecipeAnvil
implements IAnvilRecipe {
    public int id = -1;
    public String name = "";
    public Availability availability = new Availability();
    public boolean ignoreRepairItemNBT = false;
    public boolean ignoreRepairMaterialNBT = false;
    public boolean ignoreRepairMaterialDamage = false;
    public ItemStack itemToRepair;
    public ItemStack repairMaterial;
    public int xpCost;
    public float repairPercentage;
    private boolean isAnvil = true;

    public RecipeAnvil() {
    }

    public RecipeAnvil(String name, ItemStack itemToRepair, ItemStack repairMaterial, int xpCost, float repairPercentage) {
        this.name = name;
        this.itemToRepair = itemToRepair;
        this.repairMaterial = repairMaterial;
        this.xpCost = xpCost;
        this.repairPercentage = repairPercentage;
    }

    public static RecipeAnvil read(NBTTagCompound compound) {
        RecipeAnvil recipe = new RecipeAnvil();
        recipe.id = compound.func_74762_e("ID");
        recipe.name = compound.func_74779_i("Name");
        recipe.availability.readFromNBT(compound.func_74775_l("Availability"));
        recipe.xpCost = compound.func_74762_e("XPCost");
        recipe.repairPercentage = compound.func_74760_g("RepairPercentage");
        recipe.itemToRepair = NoppesUtilServer.readItem(compound.func_74775_l("ItemToRepair"));
        recipe.repairMaterial = NoppesUtilServer.readItem(compound.func_74775_l("RepairMaterial"));
        recipe.ignoreRepairMaterialNBT = compound.func_74767_n("IgnoreRepairMatNBT");
        recipe.ignoreRepairItemNBT = compound.func_74767_n("IgnoreRepairItemNBT");
        recipe.ignoreRepairMaterialDamage = compound.func_74767_n("IgnoreRepairMatDamage");
        recipe.isAnvil = true;
        return recipe;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("Name", this.name);
        compound.func_74782_a("Availability", (NBTBase)this.availability.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("XPCost", this.xpCost);
        compound.func_74776_a("RepairPercentage", this.repairPercentage);
        if (this.itemToRepair != null) {
            compound.func_74782_a("ItemToRepair", (NBTBase)NoppesUtilServer.writeItem(this.itemToRepair, new NBTTagCompound()));
        }
        if (this.repairMaterial != null) {
            compound.func_74782_a("RepairMaterial", (NBTBase)NoppesUtilServer.writeItem(this.repairMaterial, new NBTTagCompound()));
        }
        compound.func_74757_a("IgnoreRepairMatNBT", this.ignoreRepairMaterialNBT);
        compound.func_74757_a("IgnoreRepairItemNBT", this.ignoreRepairItemNBT);
        compound.func_74757_a("IgnoreRepairMatDamage", this.ignoreRepairMaterialDamage);
        compound.func_74757_a("IsAnvil", true);
        return compound;
    }

    @Override
    public int getXpCost() {
        return this.xpCost;
    }

    @Override
    public float getRepairPercentage() {
        return this.repairPercentage;
    }

    @Override
    public boolean matches(ItemStack inputItem, ItemStack inputRepairMaterial) {
        if (inputItem == null || inputRepairMaterial == null) {
            return false;
        }
        if (!NoppesUtilPlayer.compareItems(this.itemToRepair, inputItem, true, this.ignoreRepairItemNBT)) {
            return false;
        }
        return NoppesUtilPlayer.compareItems(this.repairMaterial, inputRepairMaterial, this.ignoreRepairMaterialDamage, this.ignoreRepairMaterialNBT);
    }

    @Override
    public ItemStack getResult(ItemStack inputItem) {
        if (inputItem == null) {
            return null;
        }
        ItemStack result = inputItem.func_77946_l();
        if (!result.func_77984_f()) {
            return result;
        }
        int maxDamage = result.func_77958_k();
        int repairAmount = (int)((float)maxDamage * this.repairPercentage);
        int currentDamage = result.func_77960_j();
        int newDamage = currentDamage - repairAmount;
        if (newDamage < 0) {
            newDamage = 0;
        }
        result.func_77964_b(newDamage);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public static RecipeAnvil saveRecipe(RecipeAnvil recipe, ItemStack output, ItemStack repairMaterial) {
        if (output != null) {
            recipe.itemToRepair = output.func_77946_l();
            if (recipe.itemToRepair.func_77984_f()) {
                recipe.itemToRepair.func_77964_b(0);
            }
        } else {
            recipe.itemToRepair = null;
        }
        recipe.repairMaterial = repairMaterial == null ? null : repairMaterial.func_77946_l();
        return recipe;
    }

    public boolean isValid() {
        return this.itemToRepair != null && this.repairMaterial != null;
    }

    public void copy(RecipeAnvil recipe) {
        this.id = recipe.id;
        this.name = recipe.name;
        this.availability = recipe.availability;
        this.ignoreRepairMaterialDamage = recipe.ignoreRepairMaterialDamage;
        this.ignoreRepairItemNBT = recipe.ignoreRepairItemNBT;
        this.ignoreRepairMaterialNBT = recipe.ignoreRepairMaterialNBT;
        this.repairPercentage = recipe.repairPercentage;
        this.xpCost = recipe.xpCost;
    }
}

