/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcs.controllers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import kamkeel.npcs.addon.DBCAddon;
import kamkeel.npcs.network.PacketHandler;
import kamkeel.npcs.network.enums.EnumSyncAction;
import kamkeel.npcs.network.enums.EnumSyncType;
import kamkeel.npcs.network.packets.data.LoginPacket;
import kamkeel.npcs.network.packets.data.large.SyncEffectPacket;
import kamkeel.npcs.network.packets.data.large.SyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.controllers.CustomEffectController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.MagicController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.data.CustomEffect;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.EffectKey;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Magic;
import noppes.npcs.controllers.data.MagicCycle;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerEffect;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.RecipeAnvil;
import noppes.npcs.controllers.data.RecipeCarpentry;

public class SyncController {
    public static void syncPlayer(EntityPlayerMP player) {
        PacketHandler.Instance.sendToPlayer(new LoginPacket(), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.FACTION, EnumSyncAction.RELOAD, -1, SyncController.factionsNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.DIALOG_CATEGORY, EnumSyncAction.RELOAD, -1, SyncController.dialogCategoriesNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.QUEST_CATEGORY, EnumSyncAction.RELOAD, -1, SyncController.questCategoriesNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.WORKBENCH_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.workbenchNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.CARPENTRY_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.carpentryNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.ANVIL_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.anvilNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.CUSTOM_EFFECTS, EnumSyncAction.RELOAD, -1, SyncController.customEffectsNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.MAGIC, EnumSyncAction.RELOAD, -1, SyncController.magicsNBT()), player);
        PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.MAGIC_CYCLE, EnumSyncAction.RELOAD, -1, SyncController.magicCyclesNBT()), player);
        DBCAddon.instance.syncPlayer(player);
        SyncController.syncPlayerData(player, false);
    }

    public static NBTTagCompound workbenchNBT() {
        RecipeController controller = RecipeController.Instance;
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (RecipeCarpentry recipe : controller.globalRecipes.values()) {
            list.func_74742_a((NBTBase)recipe.writeNBT());
        }
        compound.func_74782_a("recipes", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound carpentryNBT() {
        RecipeController controller = RecipeController.Instance;
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (RecipeCarpentry recipe : controller.carpentryRecipes.values()) {
            list.func_74742_a((NBTBase)recipe.writeNBT());
        }
        compound.func_74782_a("recipes", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound anvilNBT() {
        RecipeController controller = RecipeController.Instance;
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (RecipeAnvil recipe : controller.anvilRecipes.values()) {
            list.func_74742_a((NBTBase)recipe.writeNBT());
        }
        compound.func_74782_a("recipes", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound factionsNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (Faction faction : FactionController.getInstance().factions.values()) {
            NBTTagCompound factioNBT = new NBTTagCompound();
            faction.writeNBT(factioNBT);
            list.func_74742_a((NBTBase)factioNBT);
        }
        compound.func_74782_a("Factions", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound dialogCategoriesNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList categoryList = new NBTTagList();
        for (DialogCategory category : DialogController.Instance.categories.values()) {
            NBTTagCompound questCompound = new NBTTagCompound();
            NBTTagList dialogList = new NBTTagList();
            for (int dialogID : category.dialogs.keySet()) {
                Dialog quest = category.dialogs.get(dialogID);
                dialogList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
            }
            questCompound.func_74782_a("Data", (NBTBase)dialogList);
            questCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
            categoryList.func_74742_a((NBTBase)questCompound);
        }
        compound.func_74782_a("DialogCategories", (NBTBase)categoryList);
        return compound;
    }

    public static NBTTagCompound questCategoriesNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList categoryList = new NBTTagList();
        for (QuestCategory category : QuestController.Instance.categories.values()) {
            NBTTagCompound questCompound = new NBTTagCompound();
            NBTTagList questList = new NBTTagList();
            for (int questID : category.quests.keySet()) {
                Quest quest = category.quests.get(questID);
                questList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
            }
            questCompound.func_74782_a("Data", (NBTBase)questList);
            questCompound.func_74782_a("CatNBT", (NBTBase)category.writeSmallNBT(new NBTTagCompound()));
            categoryList.func_74742_a((NBTBase)questCompound);
        }
        compound.func_74782_a("QuestCategories", (NBTBase)categoryList);
        return compound;
    }

    public static NBTTagCompound customEffectsNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (CustomEffect effect : CustomEffectController.getInstance().getCustomEffects().values()) {
            list.func_74742_a((NBTBase)effect.writeToNBT(false));
        }
        compound.func_74782_a("Data", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound magicsNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (Magic magic : MagicController.getInstance().magics.values()) {
            NBTTagCompound magicCompound = new NBTTagCompound();
            magic.writeNBT(magicCompound);
            list.func_74742_a((NBTBase)magicCompound);
        }
        compound.func_74782_a("Data", (NBTBase)list);
        return compound;
    }

    public static NBTTagCompound magicCyclesNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        for (MagicCycle cycle : MagicController.getInstance().cycles.values()) {
            NBTTagCompound cycleCompound = new NBTTagCompound();
            cycle.writeNBT(cycleCompound);
            list.func_74742_a((NBTBase)cycleCompound);
        }
        compound.func_74782_a("Data", (NBTBase)list);
        return compound;
    }

    public static void syncPlayerData(EntityPlayerMP player, boolean update) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data != null) {
            if (update) {
                PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.PLAYERDATA, EnumSyncAction.UPDATE, -1, data.getSyncNBT()), player);
            } else {
                PacketHandler.Instance.sendToPlayer(new SyncPacket(EnumSyncType.PLAYERDATA, EnumSyncAction.RELOAD, -1, data.getSyncNBTFull()), player);
            }
        }
    }

    public static void syncRemove(EnumSyncType enumSyncType, int id) {
        PacketHandler.Instance.sendToAll(new SyncPacket(enumSyncType, EnumSyncAction.REMOVE, id, new NBTTagCompound()));
    }

    public static void syncAllDialogs() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.DIALOG_CATEGORY, EnumSyncAction.RELOAD, -1, SyncController.dialogCategoriesNBT()));
    }

    public static void syncAllQuests() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.QUEST_CATEGORY, EnumSyncAction.RELOAD, -1, SyncController.questCategoriesNBT()));
    }

    public static void syncAllWorkbenchRecipes() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.WORKBENCH_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.workbenchNBT()));
    }

    public static void syncAllCarpentryRecipes() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.CARPENTRY_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.carpentryNBT()));
    }

    public static void syncAllAnvilRecipes() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.ANVIL_RECIPES, EnumSyncAction.RELOAD, -1, SyncController.anvilNBT()));
    }

    public static void syncAllCustomEffects() {
        PacketHandler.Instance.sendToAll(new SyncPacket(EnumSyncType.CUSTOM_EFFECTS, EnumSyncAction.RELOAD, -1, SyncController.customEffectsNBT()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientSync(EnumSyncType enumSyncType, NBTTagCompound fullCompound) {
        switch (enumSyncType) {
            case FACTION: {
                NBTTagList list = fullCompound.func_150295_c("Factions", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Faction faction = new Faction();
                    faction.readNBT(list.func_150305_b(i));
                    FactionController.getInstance().factionsSync.put(faction.id, faction);
                }
                FactionController.getInstance().factions = FactionController.getInstance().factionsSync;
                FactionController.getInstance().factionsSync = new HashMap();
                break;
            }
            case DIALOG_CATEGORY: {
                if (!fullCompound.func_82582_d()) {
                    NBTTagList categories = fullCompound.func_150295_c("DialogCategories", 10);
                    for (int j = 0; j < fullCompound.func_150295_c("DialogCategories", 10).func_74745_c(); ++j) {
                        NBTTagCompound categoryCompound = categories.func_150305_b(j);
                        if (categoryCompound.func_82582_d()) continue;
                        Object category = new DialogCategory();
                        ((DialogCategory)category).readSmallNBT(categoryCompound.func_74775_l("CatNBT"));
                        NBTTagList dialogList = categoryCompound.func_150295_c("Data", 10);
                        if (DialogController.Instance.categoriesSync.containsKey(((DialogCategory)category).id)) {
                            category = DialogController.Instance.categoriesSync.get(((DialogCategory)category).id);
                            ((DialogCategory)category).readSmallNBT(categoryCompound.func_74775_l("CatNBT"));
                        }
                        for (int i = 0; i < dialogList.func_74745_c(); ++i) {
                            Dialog dialog = new Dialog();
                            dialog.readNBT(dialogList.func_150305_b(i));
                            dialog.category = category;
                            ((DialogCategory)category).dialogs.put(dialog.id, dialog);
                        }
                        DialogController.Instance.categoriesSync.put(((DialogCategory)category).id, (DialogCategory)category);
                    }
                }
                HashMap<Integer, Dialog> dialogs = new HashMap<Integer, Dialog>();
                for (DialogCategory category : DialogController.Instance.categoriesSync.values()) {
                    for (Dialog dialog : category.dialogs.values()) {
                        dialogs.put(dialog.id, dialog);
                    }
                }
                DialogController.Instance.categories = DialogController.Instance.categoriesSync;
                DialogController.Instance.dialogs = dialogs;
                DialogController.Instance.categoriesSync = new HashMap();
                break;
            }
            case QUEST_CATEGORY: {
                if (!fullCompound.func_82582_d()) {
                    NBTTagList categories = fullCompound.func_150295_c("QuestCategories", 10);
                    for (int j = 0; j < fullCompound.func_150295_c("QuestCategories", 10).func_74745_c(); ++j) {
                        NBTTagCompound categoryCompound = categories.func_150305_b(j);
                        if (categoryCompound.func_82582_d()) continue;
                        Object category = new QuestCategory();
                        ((QuestCategory)category).readSmallNBT(categoryCompound.func_74775_l("CatNBT"));
                        NBTTagList questList = categoryCompound.func_150295_c("Data", 10);
                        if (QuestController.Instance.categoriesSync.containsKey(((QuestCategory)category).id)) {
                            category = QuestController.Instance.categoriesSync.get(((QuestCategory)category).id);
                            ((QuestCategory)category).readSmallNBT(categoryCompound.func_74775_l("CatNBT"));
                        }
                        for (int i = 0; i < questList.func_74745_c(); ++i) {
                            Quest quest = new Quest();
                            quest.readNBT(questList.func_150305_b(i));
                            quest.category = category;
                            ((QuestCategory)category).quests.put(quest.id, quest);
                        }
                        QuestController.Instance.categoriesSync.put(((QuestCategory)category).id, (QuestCategory)category);
                    }
                }
                HashMap<Integer, Quest> quests = new HashMap<Integer, Quest>();
                for (QuestCategory category : QuestController.Instance.categoriesSync.values()) {
                    for (Quest quest : category.quests.values()) {
                        quests.put(quest.id, quest);
                    }
                }
                QuestController.Instance.categories = QuestController.Instance.categoriesSync;
                QuestController.Instance.quests = quests;
                QuestController.Instance.categoriesSync = new HashMap();
                break;
            }
            case PLAYERDATA: {
                ClientCacheHandler.playerData.setSyncNBTFull(fullCompound);
                break;
            }
            case MAGIC: {
                NBTTagList list = fullCompound.func_150295_c("Data", 10);
                MagicController mc = MagicController.getInstance();
                mc.magicSync.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Magic magic = new Magic();
                    magic.readNBT(list.func_150305_b(i));
                    mc.magicSync.put(magic.id, magic);
                }
                mc.magics.clear();
                mc.magics.putAll(mc.magicSync);
                mc.magicSync.clear();
                break;
            }
            case MAGIC_CYCLE: {
                NBTTagList list = fullCompound.func_150295_c("Data", 10);
                MagicController mc = MagicController.getInstance();
                mc.cyclesSync.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    MagicCycle cycle = new MagicCycle();
                    cycle.readNBT(list.func_150305_b(i));
                    mc.cyclesSync.put(cycle.id, cycle);
                }
                mc.cycles.clear();
                mc.cycles.putAll(mc.cyclesSync);
                mc.cyclesSync.clear();
                break;
            }
            case WORKBENCH_RECIPES: {
                NBTTagList list = fullCompound.func_150295_c("recipes", 10);
                if (list == null) {
                    return;
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    RecipeCarpentry recipe = RecipeCarpentry.read(list.func_150305_b(i));
                    RecipeController.syncRecipes.put(recipe.id, recipe);
                }
                RecipeController.reloadGlobalRecipes(RecipeController.syncRecipes);
                RecipeController.syncRecipes = new HashMap();
                break;
            }
            case CARPENTRY_RECIPES: {
                NBTTagList list = fullCompound.func_150295_c("recipes", 10);
                if (list == null) {
                    return;
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    RecipeCarpentry recipe = RecipeCarpentry.read(list.func_150305_b(i));
                    RecipeController.syncRecipes.put(recipe.id, recipe);
                }
                RecipeController.Instance.carpentryRecipes = RecipeController.syncRecipes;
                RecipeController.syncRecipes = new HashMap();
                break;
            }
            case ANVIL_RECIPES: {
                NBTTagList list = fullCompound.func_150295_c("recipes", 10);
                if (list == null) {
                    return;
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    RecipeAnvil recipe = RecipeAnvil.read(list.func_150305_b(i));
                    RecipeController.syncAnvilRecipes.put(recipe.id, recipe);
                }
                RecipeController.Instance.anvilRecipes = RecipeController.syncAnvilRecipes;
                RecipeController.syncAnvilRecipes = new HashMap();
                break;
            }
            case CUSTOM_EFFECTS: {
                NBTTagList list = fullCompound.func_150295_c("Data", 10);
                CustomEffectController ce = CustomEffectController.getInstance();
                ce.customEffectsSync.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    CustomEffect effect = new CustomEffect();
                    effect.readFromNBT(list.func_150305_b(i));
                    ClientCacheHandler.getImageData(effect.icon);
                    ce.customEffectsSync.put(effect.id, effect);
                }
                ce.getCustomEffects().clear();
                ce.getCustomEffects().putAll(ce.customEffectsSync);
                ce.customEffectsSync.clear();
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientUpdate(EnumSyncType enumSyncType, int category_id, NBTTagCompound compound) {
        switch (enumSyncType) {
            case FACTION: {
                Faction faction = new Faction();
                faction.readNBT(compound);
                FactionController.getInstance().factions.put(faction.id, faction);
                break;
            }
            case DIALOG: {
                DialogCategory category = DialogController.Instance.categories.get(category_id);
                Dialog dialog = new Dialog();
                dialog.category = category;
                dialog.readNBT(compound);
                DialogController.Instance.dialogs.put(dialog.id, dialog);
                category.dialogs.put(dialog.id, dialog);
                break;
            }
            case QUEST: {
                QuestCategory category = QuestController.Instance.categories.get(category_id);
                Quest quest = new Quest();
                quest.category = category;
                quest.readNBT(compound);
                QuestController.Instance.quests.put(quest.id, quest);
                category.quests.put(quest.id, quest);
                break;
            }
            case QUEST_CATEGORY: {
                QuestCategory category = new QuestCategory();
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
                NBTTagList list = compound.func_150295_c("Data", 10);
                if (QuestController.Instance.categoriesSync.containsKey(category.id)) {
                    category = QuestController.Instance.categoriesSync.get(category.id);
                    category.readSmallNBT(compound.func_74775_l("CatNBT"));
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Quest quest = new Quest();
                    quest.readNBT(list.func_150305_b(i));
                    quest.category = category;
                    category.quests.put(quest.id, quest);
                }
                QuestController.Instance.categories.put(category.id, category);
                break;
            }
            case DIALOG_CATEGORY: {
                DialogCategory category = new DialogCategory();
                category.readSmallNBT(compound.func_74775_l("CatNBT"));
                NBTTagList list = compound.func_150295_c("Data", 10);
                if (DialogController.Instance.categoriesSync.containsKey(category.id)) {
                    category = DialogController.Instance.categoriesSync.get(category.id);
                    category.readSmallNBT(compound.func_74775_l("CatNBT"));
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Dialog dialog = new Dialog();
                    dialog.readNBT(list.func_150305_b(i));
                    dialog.category = category;
                    category.dialogs.put(dialog.id, dialog);
                }
                DialogController.Instance.categories.put(category.id, category);
                break;
            }
            case MAGIC_CYCLE: {
                MagicCycle cycle = new MagicCycle();
                cycle.readNBT(compound);
                MagicController.getInstance().cycles.put(cycle.id, cycle);
                break;
            }
            case MAGIC: {
                Magic magic = new Magic();
                magic.readNBT(compound);
                MagicController.getInstance().magics.put(magic.id, magic);
                break;
            }
            case PLAYERDATA: {
                ClientCacheHandler.playerData.setSyncNBT(compound);
                break;
            }
            case CUSTOM_EFFECTS: {
                CustomEffect effect = new CustomEffect();
                effect.readFromNBT(compound);
                ClientCacheHandler.getImageData(effect.icon);
                CustomEffectController.Instance.getCustomEffects().put(effect.id, effect);
                break;
            }
        }
    }

    public static void syncUpdate(EnumSyncType type, int cat, NBTTagCompound compound) {
        PacketHandler.Instance.sendToAll(new SyncPacket(type, EnumSyncAction.UPDATE, cat, compound));
    }

    public static NBTTagCompound updateQuestCat(QuestCategory questCategory) {
        NBTTagCompound questCompound = new NBTTagCompound();
        NBTTagList questList = new NBTTagList();
        for (int questID : questCategory.quests.keySet()) {
            Quest quest = questCategory.quests.get(questID);
            questList.func_74742_a((NBTBase)quest.writeToNBT(new NBTTagCompound()));
        }
        questCompound.func_74782_a("Data", (NBTBase)questList);
        questCompound.func_74782_a("CatNBT", (NBTBase)questCategory.writeSmallNBT(new NBTTagCompound()));
        return questCompound;
    }

    public static NBTTagCompound updateDialogCat(DialogCategory dialogCategory) {
        NBTTagCompound dialogCompound = new NBTTagCompound();
        NBTTagList dialogList = new NBTTagList();
        for (int questID : dialogCategory.dialogs.keySet()) {
            Dialog dialog = dialogCategory.dialogs.get(questID);
            dialogList.func_74742_a((NBTBase)dialog.writeToNBT(new NBTTagCompound()));
        }
        dialogCompound.func_74782_a("Data", (NBTBase)dialogList);
        dialogCompound.func_74782_a("CatNBT", (NBTBase)dialogCategory.writeSmallNBT(new NBTTagCompound()));
        return dialogCompound;
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientSyncRemove(EnumSyncType enumSyncType, int id) {
        switch (enumSyncType) {
            case FACTION: {
                FactionController.getInstance().factions.remove(id);
                break;
            }
            case DIALOG: {
                Dialog dialog = DialogController.Instance.dialogs.remove(id);
                if (dialog == null) break;
                dialog.category.dialogs.remove(id);
                break;
            }
            case DIALOG_CATEGORY: {
                DialogCategory dialogCategory = DialogController.Instance.categories.remove(id);
                if (dialogCategory == null) break;
                DialogController.Instance.dialogs.keySet().removeAll(dialogCategory.dialogs.keySet());
                break;
            }
            case QUEST: {
                Quest quest = QuestController.Instance.quests.remove(id);
                if (quest == null) break;
                quest.category.quests.remove(id);
                break;
            }
            case QUEST_CATEGORY: {
                QuestCategory questCategory = QuestController.Instance.categories.remove(id);
                if (questCategory == null) break;
                QuestController.Instance.quests.keySet().removeAll(questCategory.quests.keySet());
                break;
            }
            case MAGIC: {
                for (MagicCycle cycle : MagicController.getInstance().cycles.values()) {
                    cycle.associations.remove(id);
                }
                MagicController.getInstance().cycles.remove(id);
                break;
            }
            case MAGIC_CYCLE: {
                MagicController.getInstance().cycles.remove(id);
                break;
            }
            case CUSTOM_EFFECTS: {
                CustomEffectController.Instance.getCustomEffects().remove(id);
            }
        }
    }

    public static void syncEffects(EntityPlayerMP playerMP) {
        ConcurrentHashMap<EffectKey, PlayerEffect> playerEffects = CustomEffectController.getInstance().getPlayerEffects((EntityPlayer)playerMP);
        PlayerData playerData = PlayerData.get((EntityPlayer)playerMP);
        playerData.effectData.setEffects(playerEffects);
        NBTTagCompound compound = playerData.getPlayerEffects();
        PacketHandler.Instance.sendToPlayer(new SyncEffectPacket(compound), playerMP);
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientSyncEffects(NBTTagCompound compound) {
        PlayerData playerData = PlayerData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (playerData != null) {
            playerData.setPlayerEffects(compound);
        }
    }
}

