/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.modelsParts;

import com.DarknessCrow.events.BleachClientEvents;
import com.DarknessCrow.modelsParts.ModelCustomObjPart;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CrowPartFlameBody
extends ModelCustomObjPart {
    private static final ResourceLocation FLAME_TEXTURE = new ResourceLocation("crow:textures/particles/flames.png");
    private final Random rand = new Random();
    private int particleCount = 28;
    private int frameCount = 16;

    public CrowPartFlameBody(ModelBase base) {
        super(base);
    }

    @Override
    public void func_78785_a(float scale) {
        super.func_78785_a(scale);
        this.renderFlames(scale);
    }

    private void renderFlames(float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator t = Tessellator.field_78398_a;
        float partialTicks = -BleachClientEvents.renderTick;
        float time = (float)mc.field_71439_g.field_70173_aa + partialTicks;
        GL11.glPushMatrix();
        if ("bipedBody".equalsIgnoreCase(this.bodyPart)) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        } else if ("bipedHead".equalsIgnoreCase(this.bodyPart)) {
            GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        mc.func_110434_K().func_110577_a(FLAME_TEXTURE);
        for (int i = 0; i < this.particleCount; ++i) {
            GL11.glPushMatrix();
            float life = (time * 0.4f + (float)i * 0.3f) % 1.0f;
            float spread = 0.5f;
            float x = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float z = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float y = life * 3.5f;
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)this.rand.nextInt(360), (float)0.0f, (float)1.0f, (float)0.0f);
            float particleScale = (1.0f - life) * (0.6f + this.rand.nextFloat() * 0.4f) * scale;
            GL11.glScalef((float)particleScale, (float)(particleScale * 1.6f), (float)particleScale);
            float alpha = 1.0f - life;
            int currentFrame = (int)(life * (float)this.frameCount) % this.frameCount;
            float vStart = (float)currentFrame / (float)this.frameCount;
            float vEnd = vStart + 1.0f / (float)this.frameCount;
            t.func_78382_b();
            t.func_78369_a(1.0f, 1.0f, 1.0f, alpha);
            t.func_78374_a(-0.5, 0.0, 0.0, 0.0, (double)vEnd);
            t.func_78374_a(0.5, 0.0, 0.0, 1.0, (double)vEnd);
            t.func_78374_a(0.5, 1.0, 0.0, 1.0, (double)vStart);
            t.func_78374_a(-0.5, 1.0, 0.0, 0.0, (double)vStart);
            t.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public CrowPartFlameBody setParticleCount(int count) {
        this.particleCount = count;
        return this;
    }

    public CrowPartFlameBody setFrameCount(int frames) {
        this.frameCount = frames;
        return this;
    }

    public CrowPartFlameBody setBodyPartString(String part) {
        this.bodyPart = part;
        return this;
    }
}

