/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.items;

import com.DarknessCrow.events.BleachClientEvents;
import com.DarknessCrow.events.ItemRenderConfig;
import com.DarknessCrow.items.CrowItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class CrowItemRenderer
implements IItemRenderer {
    private static final String MODEL_PATH = "crow:outros/models/items/";
    private static final String TEXTURE_PATH = "crow:outros/models/items/";
    private static final ResourceLocation FLAME_TEXTURE = new ResourceLocation("crow:textures/particles/flames.png");
    private String fileName;
    private ResourceLocation modelLocation;
    private ResourceLocation textureLocation;
    private IModelCustom model;
    private final Random rand = new Random();
    public static float offsetX = 0.4f;
    public static float offsetY = 0.7f;
    public static float offsetZ = -0.5f;
    public static float rotationX = 240.0f;
    public static float rotationY = -45.0f;
    public static float rotationZ = 180.0f;
    public static float scalef = 0.5f;

    public CrowItemRenderer(String fileName) {
        this.fileName = fileName;
        this.modelLocation = new ResourceLocation("crow:outros/models/items/" + fileName + ".obj");
        this.textureLocation = new ResourceLocation("crow:outros/models/items/" + fileName + "TEX.png");
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)this.modelLocation);
    }

    public void setTex(String path) {
        this.textureLocation = new ResourceLocation(path);
    }

    public void setModel(String path) {
        this.modelLocation = new ResourceLocation(path);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureLocation);
            GL11.glScalef((float)0.025f, (float)0.025f, (float)0.025f);
            GL11.glRotated((double)200.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslatef((float)-50.0f, (float)35.0f, (float)4.5f);
            this.model.renderOnly(new String[]{"sword"});
            this.effFPerson(item, 0.0f);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureLocation);
            GL11.glScalef((float)0.02f, (float)0.02f, (float)0.02f);
            GL11.glRotated((double)220.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslatef((float)-32.5f, (float)40.0f, (float)0.0f);
            this.model.renderOnly(new String[]{"sword"});
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureLocation);
            GL11.glScalef((float)0.02f, (float)0.02f, (float)0.02f);
            GL11.glRotated((double)220.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslatef((float)-32.5f, (float)40.0f, (float)0.0f);
            this.model.renderAll();
            GL11.glPopMatrix();
        }
    }

    private void effFPerson(ItemStack item, float partialTicks) {
        if (item == null || !(item.func_77973_b() instanceof CrowItem)) {
            return;
        }
        String itemName = item.func_77977_a();
        ItemRenderConfig.Transform transform = ItemRenderConfig.getTransformForItemName(itemName);
        if (transform == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        if ("flames".equalsIgnoreCase(transform.eff)) {
            GL11.glScalef((float)40.5f, (float)40.5f, (float)40.5f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.1f);
            GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(FLAME_TEXTURE);
            this.renderFlameLayers(tess, partialTicks);
        } else if ("lightning".equalsIgnoreCase(transform.eff)) {
            GL11.glScalef((float)60.0f, (float)60.0f, (float)60.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.lightningAlongBlade();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderFlameLayers(Tessellator t, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        float time = (float)mc.field_71439_g.field_70173_aa + partialTicks;
        int particles = 28;
        for (int i = 0; i < particles; ++i) {
            GL11.glPushMatrix();
            float life = (time * 0.4f + (float)i * 0.3f) % 1.0f;
            float spread = 1.0f;
            float x = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float z = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float y = life * 5.0f;
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)this.rand.nextInt(360), (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = (1.2f - life) * (0.7f + this.rand.nextFloat() * 0.3f);
            GL11.glScalef((float)scale, (float)(scale * 1.6f), (float)scale);
            float alpha = 1.0f - life;
            int frameCount = 16;
            int currentFrame = (int)(life * (float)frameCount) % frameCount;
            float vStart = (float)currentFrame / (float)frameCount;
            float vEnd = vStart + 1.0f / (float)frameCount;
            t.func_78382_b();
            t.func_78369_a(1.0f, 1.0f, 1.0f, alpha);
            t.func_78374_a(-0.5, 0.0, 0.0, 0.0, (double)vEnd);
            t.func_78374_a(0.5, 0.0, 0.0, 1.0, (double)vEnd);
            t.func_78374_a(0.5, 1.0, 0.0, 1.0, (double)vStart);
            t.func_78374_a(-0.5, 1.0, 0.0, 0.0, (double)vStart);
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void lightningAlongBlade() {
        Tessellator tess = Tessellator.field_78398_a;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glLineWidth((float)2.0f);
        int sparks = 4;
        float partialTicks = -BleachClientEvents.renderTick;
        float time = (float)mc.field_71439_g.field_70173_aa + partialTicks;
        for (int s = 0; s < sparks; ++s) {
            Random rand = new Random((long)(time * 1000.0f + (float)(s * 999)));
            double x = 0.0;
            double z = 0.0;
            tess.func_78371_b(3);
            tess.func_78369_a(0.5f, 0.7f, 1.0f, 0.9f);
            for (int i = 0; i < 12; ++i) {
                double y = (double)i * 0.15;
                tess.func_78377_a(x += ((double)rand.nextFloat() - 0.5) * 0.08, y, z += ((double)rand.nextFloat() - 0.5) * 0.08);
            }
            tess.func_78381_a();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }
}

