/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.events;

import com.DarknessCrow.events.ItemRenderConfig;
import com.DarknessCrow.items.CrowItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class SwordFlame3DRenderer {
    public static float offsetX = 0.4f;
    public static float offsetY = 0.7f;
    public static float offsetZ = -0.5f;
    public static float rotationX = 240.0f;
    public static float rotationY = -45.0f;
    public static float rotationZ = 180.0f;
    public static float scalef = 0.5f;
    private static final ResourceLocation FLAME_TEXTURE = new ResourceLocation("crow:textures/particles/flames.png");
    private final Random rand = new Random();

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Specials.Post event) {
        this.renderFlameForPlayer(event.entityPlayer, event.renderer.field_77109_a, event.partialRenderTick, true);
    }

    private void renderFlameForPlayer(EntityPlayer player, ModelBiped model, float partialTicks, boolean useModelTransform) {
        ItemStack held = player.func_70694_bm();
        if (held == null || !(held.func_77973_b() instanceof CrowItem)) {
            return;
        }
        String itemName = held.func_77977_a();
        ItemRenderConfig.Transform transform = ItemRenderConfig.getTransformForItemName(itemName);
        if (transform == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        if ("flames".equalsIgnoreCase(transform.eff)) {
            if (useModelTransform) {
                model.field_78112_f.func_78794_c(0.0625f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)0.0f, (float)0.9f, (float)-0.4f);
                GL11.glRotatef((float)265.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            mc.func_110434_K().func_110577_a(FLAME_TEXTURE);
            this.renderFlameLayers(tess, player, partialTicks);
        } else if ("flameBody".equalsIgnoreCase(transform.eff)) {
            GL11.glPushMatrix();
            float[][] poses = new float[][]{{-1.3f, 0.4f, 1.4f, 105.0f, -30.0f, 250.0f}, {-1.3f, 0.4f, 1.4f, 80.0f, -30.0f, 220.0f}, {-1.3f, -0.4f, 1.4f, 65.0f, -30.0f, 190.0f}, {-1.3f, -0.4f, 1.4f, 65.0f, -30.0f, 250.0f}};
            switch (transform.part.toLowerCase()) {
                case "bipedbody": {
                    model.field_78115_e.func_78794_c(0.0625f);
                    break;
                }
                case "bipedhead": {
                    model.field_78116_c.func_78794_c(0.0625f);
                    break;
                }
                case "bipedleftarm": {
                    model.field_78113_g.func_78794_c(0.0625f);
                    break;
                }
                case "bipedrightarm": {
                    model.field_78112_f.func_78794_c(0.0625f);
                }
            }
            GL11.glScalef((float)transform.scale, (float)transform.scale, (float)transform.scale);
            GL11.glRotatef((float)transform.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)transform.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)transform.rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)transform.offsetX, (float)transform.offsetY, (float)transform.offsetZ);
            mc.func_110434_K().func_110577_a(FLAME_TEXTURE);
            for (Object pose : (String)poses) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)pose[0], (float)pose[1], (float)pose[2]);
                GL11.glRotatef((float)pose[3], (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)pose[4], (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)pose[5], (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderFlameLayers(tess, player, partialTicks);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderFlameLayers(Tessellator t, EntityPlayer player, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        float time = ((float)player.field_70173_aa + partialTicks) * 0.15f;
        int particles = 28;
        for (int i = 0; i < particles; ++i) {
            GL11.glPushMatrix();
            float life = (time * 0.4f + (float)i * 0.3f) % 1.0f;
            float spread = 1.0f;
            float x = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float z = (this.rand.nextFloat() - 0.5f) * spread * life * 2.0f;
            float y = life * 5.0f;
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)this.rand.nextInt(360), (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = (1.2f - life) * (0.7f + this.rand.nextFloat() * 0.3f);
            GL11.glScalef((float)scale, (float)(scale * 1.6f), (float)scale);
            float alpha = 1.0f - life;
            int frameCount = 16;
            int currentFrame = (int)(life * (float)frameCount) % frameCount;
            float vStart = (float)currentFrame / (float)frameCount;
            float vEnd = vStart + 1.0f / (float)frameCount;
            t.func_78382_b();
            t.func_78369_a(1.0f, 1.0f, 1.0f, alpha);
            t.func_78374_a(-0.5, 0.0, 0.0, 0.0, (double)vEnd);
            t.func_78374_a(0.5, 0.0, 0.0, 1.0, (double)vEnd);
            t.func_78374_a(0.5, 1.0, 0.0, 1.0, (double)vStart);
            t.func_78374_a(-0.5, 1.0, 0.0, 0.0, (double)vStart);
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

