/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.network;

import com.DarknessCrow.main.mainRegistry;
import com.DarknessCrow.modelsParts.ModelCustomObj;
import com.DarknessCrow.network.ClientModelPartsStorage;
import com.DarknessCrow.network.ModelRegistry;
import com.DarknessCrow.network.PacketHelper;
import com.DarknessCrow.network.ServerModelPartsStorage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int[] parts = ServerModelPartsStorage.getModelParts(player);
            PacketHelper.sendModelPartsToNearbyPlayers(parts, player, mainRegistry.modInstance);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayerSpecials(RenderPlayerEvent.Specials.Post event) {
        EntityPlayer player = event.entityPlayer;
        int[] parts = ClientModelPartsStorage.getModelParts(player);
        if (parts.length == 0) {
            return;
        }
        ModelBiped biped = event.renderer.field_77109_a;
        for (int id : parts) {
            List<ModelCustomObj> modelList = ModelRegistry.get(id);
            for (ModelCustomObj model : modelList) {
                ModelRenderer part;
                if (model == null || (part = this.getBodyPartRenderer(biped, model.bodyPart)) == null) continue;
                GL11.glPushMatrix();
                part.func_78794_c(0.0625f);
                model.func_78785_a(1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    private ModelRenderer getBodyPartRenderer(ModelBiped biped, String partName) {
        switch (partName) {
            case "bipedHead": {
                return biped.field_78116_c;
            }
            case "bipedBody": {
                return biped.field_78115_e;
            }
            case "bipedRightArm": {
                return biped.field_78112_f;
            }
            case "bipedLeftArm": {
                return biped.field_78113_g;
            }
            case "bipedRightLeg": {
                return biped.field_78123_h;
            }
            case "bipedLeftLeg": {
                return biped.field_78124_i;
            }
            case "none": {
                return null;
            }
        }
        return null;
    }
}

