/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.handler.IAnimationHandler;
import noppes.npcs.api.handler.data.IAnimation;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Animation;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.util.NBTJsonUtil;

public class AnimationController
implements IAnimationHandler {
    public HashMap<Integer, Animation> animations;
    private HashMap<Integer, String> bootOrder;
    public static AnimationController Instance;
    private int lastUsedID = 0;

    public AnimationController() {
        Instance = this;
        this.bootOrder = new HashMap();
        this.animations = new HashMap();
        this.load();
    }

    public static AnimationController getInstance() {
        return Instance;
    }

    public void load() {
        LogWriter.info("Loading animations...");
        this.readAnimationMap();
        this.loadAnimations();
        LogWriter.info("Done loading animations.");
    }

    private void loadAnimations() {
        this.animations.clear();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try {
                    Animation animation = new Animation();
                    animation.readFromNBT(NBTJsonUtil.LoadFile(file));
                    animation.name = file.getName().substring(0, file.getName().length() - 5);
                    if (animation.id == -1) {
                        animation.id = this.getUnusedId();
                    }
                    int originalID = animation.id;
                    int setID = animation.id;
                    while (!(!this.bootOrder.containsKey(setID) && !this.animations.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(animation.name))) {
                        ++setID;
                    }
                    animation.id = setID;
                    if (originalID != setID) {
                        LogWriter.info("Found Animation ID Mismatch: " + animation.name + ", New ID: " + setID);
                        animation.save();
                    }
                    this.animations.put(animation.id, animation);
                }
                catch (Exception e) {
                    LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
                }
            }
        }
        this.saveAnimationMap();
    }

    private File getDir() {
        return new File(CustomNpcs.getWorldSaveDirectory(), "animations");
    }

    public int getUnusedId() {
        if (this.lastUsedID == 0) {
            for (int catid : this.animations.keySet()) {
                if (catid <= this.lastUsedID) continue;
                this.lastUsedID = catid;
            }
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    @Override
    public IAnimation saveAnimation(IAnimation animation) {
        if (animation.getID() < 0) {
            animation.setID(this.getUnusedId());
            while (this.hasName(animation.getName())) {
                animation.setName(animation.getName() + "_");
            }
        } else {
            Animation existing = this.animations.get(animation.getID());
            if (existing != null && !existing.name.equals(animation.getName())) {
                while (this.hasName(animation.getName())) {
                    animation.setName(animation.getName() + "_");
                }
            }
        }
        this.animations.remove(animation.getID());
        this.animations.put(animation.getID(), (Animation)animation);
        for (PlayerData playerData : PlayerDataController.Instance.getAllPlayerData()) {
            playerData.animationData.uncacheAnimation(animation.getID());
        }
        this.saveAnimationMap();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, animation.getName() + ".json_new");
        File file2 = new File(dir, animation.getName() + ".json");
        try {
            NBTJsonUtil.SaveFile(file, ((Animation)animation).writeToNBT());
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        return this.animations.get(animation.getID());
    }

    public boolean hasName(String newName) {
        if (newName.trim().isEmpty()) {
            return true;
        }
        for (Animation animation : this.animations.values()) {
            if (!animation.name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(String name) {
        Animation foundAnimation;
        Animation delete = this.getAnimationFromName(name);
        if (delete != null && (foundAnimation = this.animations.remove(delete.getID())) != null && foundAnimation.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundAnimation.name + ".json")) continue;
                file.delete();
                break;
            }
            this.saveAnimationMap();
        }
    }

    @Override
    public void delete(int id) {
        if (!this.animations.containsKey(id)) {
            return;
        }
        Animation foundAnimation = this.animations.remove(id);
        if (foundAnimation != null && foundAnimation.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundAnimation.name + ".json")) continue;
                file.delete();
                break;
            }
            this.saveAnimationMap();
        }
    }

    @Override
    public boolean has(String name) {
        return this.getAnimationFromName(name) != null;
    }

    @Override
    public IAnimation get(String name) {
        return this.getAnimationFromName(name);
    }

    @Override
    public IAnimation get(int id) {
        return this.animations.get(id);
    }

    @Override
    public IAnimation[] getAnimations() {
        ArrayList<Animation> animations = new ArrayList<Animation>(this.animations.values());
        return animations.toArray(new IAnimation[0]);
    }

    public Animation getAnimationFromName(String animation) {
        for (Map.Entry<Integer, Animation> entryAnimation : AnimationController.getInstance().animations.entrySet()) {
            if (!entryAnimation.getValue().name.equalsIgnoreCase(animation)) continue;
            return entryAnimation.getValue();
        }
        return null;
    }

    public String[] getNames() {
        String[] names = new String[this.animations.size()];
        int i = 0;
        for (Animation animation : this.animations.values()) {
            names[i] = animation.name.toLowerCase();
            ++i;
        }
        return names;
    }

    public File getMapDir() {
        File dir = CustomNpcs.getWorldSaveDirectory();
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void readAnimationMap() {
        this.bootOrder.clear();
        try {
            File file = new File(this.getMapDir(), "animations.dat");
            if (file.exists()) {
                this.loadAnimationMapFile(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(this.getMapDir(), "animations.dat_old");
                if (file.exists()) {
                    this.loadAnimationMapFile(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NBTTagCompound writeMapNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList animationList = new NBTTagList();
        for (Integer key : this.animations.keySet()) {
            Animation animation = this.animations.get(key);
            if (animation.getName().isEmpty()) continue;
            NBTTagCompound animationCompound = new NBTTagCompound();
            animationCompound.func_74778_a("Name", animation.getName());
            animationCompound.func_74768_a("ID", key.intValue());
            animationList.func_74742_a((NBTBase)animationCompound);
        }
        nbt.func_74782_a("Animations", (NBTBase)animationList);
        return nbt;
    }

    public void readMapNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("Animations", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                String animationName = nbttagcompound.func_74779_i("Name");
                Integer key = nbttagcompound.func_74762_e("ID");
                this.bootOrder.put(key, animationName);
            }
        }
    }

    private void loadAnimationMapFile(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.readAnimationMap(var1);
        var1.close();
    }

    public void readAnimationMap(DataInputStream stream) throws IOException {
        NBTTagCompound nbtCompound = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.readMapNBT(nbtCompound);
    }

    public void saveAnimationMap() {
        try {
            File saveDir = this.getMapDir();
            File file = new File(saveDir, "animations.dat_new");
            File file1 = new File(saveDir, "animations.dat_old");
            File file2 = new File(saveDir, "animations.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeMapNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }
}

