/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.config.ConfigClient;
import noppes.npcs.controllers.data.Quest;
import org.lwjgl.opengl.GL11;

public class OverlayQuestTracking
extends Gui {
    public Minecraft mc;
    private ScaledResolution res = null;
    public static int scaledWidth = 0;
    public static int scaledHeight = 0;
    int color = 0xFFFFFF;
    float alpha = 1.0f;
    private boolean randomStyle = false;
    private boolean boldStyle = false;
    private boolean italicStyle = false;
    private boolean underlineStyle = false;
    private boolean strikethroughStyle = false;
    private boolean bidiFlag = false;
    private boolean unicodeFlag = false;
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    private final FontRenderer fontRenderer;
    protected final ResourceLocation locationFontTexture;
    protected int[] charWidth;
    protected byte[] glyphWidth;
    private final int[] colorCode;
    private float red;
    private float green;
    private float blue;
    private float posX;
    private float posY;
    private float renderOffsetY;
    private final int overlayWidth = 120;
    public ArrayList<String> trackedQuestLines;
    public ArrayList<String> categoryNameLines;
    public ArrayList<String> objectiveLines;
    public ArrayList<String> turnInText;

    public OverlayQuestTracking(Minecraft mc) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.locationFontTexture = new ResourceLocation("textures/font/ascii.png");
        this.charWidth = new int[256];
        this.glyphWidth = new byte[65536];
        this.colorCode = new int[32];
        this.overlayWidth = 120;
        this.trackedQuestLines = new ArrayList();
        this.categoryNameLines = new ArrayList();
        this.objectiveLines = new ArrayList();
        this.turnInText = new ArrayList();
        this.mc = mc;
        this.readFontTexture();
        this.readGlyphSizes();
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.colorCode[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }

    public void initOverlay() {
        this.res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        scaledWidth = this.res.func_78326_a();
        scaledHeight = this.res.func_78328_b();
    }

    public void setOverlayData(NBTTagCompound compound) {
        Quest trackedQuest = new Quest();
        trackedQuest.readNBT(compound.func_74775_l("Quest"));
        this.trackedQuestLines = this.getLineList(trackedQuest.getName());
        this.categoryNameLines = this.getLineList(compound.func_74779_i("CategoryName"));
        NBTTagList nbtTagList = compound.func_150295_c("ObjectiveList", 8);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            boolean completed;
            String objective;
            block8: {
                objective = nbtTagList.func_150307_f(i);
                String[] split = objective.split(":");
                split = split[split.length - 1].split("/");
                completed = false;
                try {
                    int total;
                    if (split.length < 2) {
                        throw new NumberFormatException("catch");
                    }
                    int killed = Integer.parseInt(split[0].trim());
                    if (killed / (total = Integer.parseInt(split[1].trim())) == 1) {
                        completed = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (!objective.endsWith("(Done)") && !objective.endsWith("(read)") && (!objective.endsWith("Found") || objective.endsWith("Not Found"))) break block8;
                    completed = true;
                }
            }
            objective = completed ? "&a&o&m" + objective : "&o" + objective;
            this.objectiveLines.add(objective);
        }
        boolean instantComplete = compound.func_74767_n("Instant");
        if (instantComplete) {
            this.turnInText.add("Completed automatically");
        } else {
            String npcName = compound.func_74779_i("TurnInNPC");
            if (!npcName.isEmpty()) {
                this.turnInText.add("Complete with " + npcName);
            }
        }
        this.initOverlay();
    }

    public ArrayList<String> getLineList(String string) {
        String[] split = string.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(split[0]);
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            if (this.fontRenderer.func_78256_a(lines.get(lines.size() - 1) + " " + s) > 100) {
                lines.add(s);
                continue;
            }
            lines.set(lines.size() - 1, lines.get(lines.size() - 1) + " " + s);
        }
        return lines;
    }

    public void renderGameOverlay(float partialTicks) {
        this.res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        float overallScale = (float)ConfigClient.TrackingScale / 100.0f;
        scaledWidth = this.res.func_78326_a();
        scaledHeight = this.res.func_78328_b();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(ConfigClient.TrackingInfoAlignment % 3) * ((float)scaledWidth / 2.0f)), (float)((float)(Math.floor(ConfigClient.TrackingInfoAlignment / 3) * (double)((float)scaledHeight / 2.0f))), (float)0.0f);
        float offsetX = ConfigClient.TrackingInfoAlignment % 3 == 0 ? 5.0f : -5.0f;
        float offsetY = ConfigClient.TrackingInfoAlignment < 3 ? 5.0f : 0.0f;
        offsetY = ConfigClient.TrackingInfoAlignment > 5 ? -5.0f : offsetY;
        GL11.glTranslatef((float)((float)ConfigClient.TrackingInfoX + offsetX), (float)((float)ConfigClient.TrackingInfoY + offsetY), (float)0.0f);
        this.red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        this.green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(this.color & 0xFF) / 255.0f;
        float centerX = -60.0f * overallScale;
        centerX = ConfigClient.TrackingInfoAlignment % 3 == 1 ? 0.0f : (centerX *= ConfigClient.TrackingInfoAlignment % 3 == 0 ? -1.0f : 1.0f);
        this.renderOffsetY = -40.0f * overallScale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)0.0f, (float)0.0f);
        this.renderStringLines(this.trackedQuestLines, 1.2f * overallScale, false, true, 0);
        GL11.glPopMatrix();
        float questTitleTop = this.renderOffsetY;
        this.renderOffsetY -= 10.0f * overallScale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)0.0f, (float)0.0f);
        this.renderStringLines(this.categoryNameLines, 0.85f * overallScale, false, false, 0);
        GL11.glPopMatrix();
        this.renderOffsetY = -10.0f * overallScale;
        GL11.glPushMatrix();
        this.renderStringLines(this.objectiveLines, 1.0f * overallScale, true, false, ConfigClient.TrackingInfoAlignment % 3 == 0 ? 1 : (ConfigClient.TrackingInfoAlignment % 3 == 2 ? 2 : 0));
        GL11.glPopMatrix();
        this.renderOffsetY += 10.0f * overallScale;
        GL11.glPushMatrix();
        this.renderStringLines(this.turnInText, 1.0f * overallScale, true, false, ConfigClient.TrackingInfoAlignment % 3 == 0 ? 1 : (ConfigClient.TrackingInfoAlignment % 3 == 2 ? 2 : 0));
        GL11.glPopMatrix();
        this.renderOffsetY = -20.0f * overallScale;
        GL11.glPushMatrix();
        if ((double)overallScale < 0.6) {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)this.renderOffsetY, -1);
        } else if ((double)overallScale < 0.8) {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)this.renderOffsetY, -5723992);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY + 1.0f), -1);
        } else {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)this.renderOffsetY, -8947849);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY + 1.0f), -5723992);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY + 2.0f), -1);
        }
        GL11.glPopMatrix();
        this.renderOffsetY = questTitleTop + 2.0f;
        GL11.glPushMatrix();
        if ((double)overallScale < 0.6) {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY - 2.0f), -1);
        } else if ((double)overallScale < 0.8) {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)this.renderOffsetY, -5723992);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY - 1.0f), -1);
        } else {
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)this.renderOffsetY, -8947849);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY - 1.0f), -5723992);
            this.func_73730_a((int)(centerX - 60.0f * overallScale), (int)(centerX + 60.0f * overallScale), (int)(this.renderOffsetY - 2.0f), -1);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
    }

    public void renderStringLines(ArrayList<String> lines, float scale, boolean downwards, boolean bold, int facing) {
        for (int i = 0; i < lines.size(); ++i) {
            String s = lines.get(i);
            if (!downwards) {
                s = lines.get(lines.size() - 1 - i);
            }
            int stringWidth = this.fontRenderer.func_78256_a(s.replace("&o", ""));
            if (s.startsWith("&a&o&m")) {
                stringWidth = this.fontRenderer.func_78256_a(s.replace("&a&o&m", ""));
            }
            float overallScale = (float)ConfigClient.TrackingScale / 100.0f;
            GL11.glPushMatrix();
            switch (facing) {
                case 0: {
                    GL11.glTranslatef((float)(scale * ((float)(-stringWidth) / 2.0f)), (float)this.renderOffsetY, (float)0.0f);
                    break;
                }
                case 1: {
                    GL11.glTranslatef((float)0.0f, (float)this.renderOffsetY, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glTranslatef((float)(scale * (float)(-stringWidth)), (float)this.renderOffsetY, (float)0.0f);
                }
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.drawString(s, 0, 0, this.color, true);
            if (bold) {
                GL11.glTranslatef((float)0.2f, (float)0.2f, (float)0.0f);
                this.drawString(s, 0, 0, this.color, false);
            }
            this.renderOffsetY += (float)(downwards ? 10 : -10) * overallScale;
            GL11.glPopMatrix();
        }
    }

    public int drawString(String p_85187_1_, int p_85187_2_, int p_85187_3_, int p_85187_4_, boolean p_85187_5_) {
        int l;
        this.resetStyles();
        if (p_85187_5_) {
            l = this.renderString(p_85187_1_, p_85187_2_ + 1, p_85187_3_ + 1, p_85187_4_, true);
            l = Math.max(l, this.renderString(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false));
        } else {
            l = this.renderString(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false);
        }
        return l;
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    private int renderString(String p_78258_1_, int p_78258_2_, int p_78258_3_, int p_78258_4_, boolean p_78258_5_) {
        if (p_78258_1_ == null) {
            return 0;
        }
        if (this.bidiFlag) {
            p_78258_1_ = this.bidiReorder(p_78258_1_);
        }
        this.setColor(this.red, this.green, this.blue, this.alpha);
        if (p_78258_5_) {
            this.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
        this.posX = p_78258_2_;
        this.posY = p_78258_3_;
        this.renderStringAtPos(p_78258_1_, p_78258_5_);
        return (int)this.posX;
    }

    private void renderStringAtPos(String p_78255_1_, boolean p_78255_2_) {
        for (int i = 0; i < p_78255_1_.length(); ++i) {
            boolean flag1;
            int k;
            int j;
            char c0 = p_78255_1_.charAt(i);
            if (c0 == '&' && i + 1 < p_78255_1_.length()) {
                j = "0123456789abcdefklmnor".indexOf(p_78255_1_.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (p_78255_2_) {
                        j += 16;
                    }
                    k = this.colorCode[j];
                    this.setColor((float)(k >> 16) / 255.0f, (float)(k >> 8 & 0xFF) / 255.0f, (float)(k & 0xFF) / 255.0f, this.alpha);
                } else if (j == 16) {
                    this.randomStyle = true;
                } else if (j == 17) {
                    this.boldStyle = true;
                } else if (j == 18) {
                    this.strikethroughStyle = true;
                } else if (j == 19) {
                    this.underlineStyle = true;
                } else if (j == 20) {
                    this.italicStyle = true;
                } else if (j == 21) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                }
                ++i;
                continue;
            }
            j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.randomStyle && j != -1) {
                while (this.charWidth[j] != this.charWidth[k = Minecraft.func_71410_x().field_71466_p.field_78289_c.nextInt(this.charWidth.length)]) {
                }
                j = k;
            }
            float f1 = this.unicodeFlag ? 0.5f : 1.0f;
            boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.unicodeFlag) && p_78255_2_;
            if (flag1) {
                this.posX -= f1;
                this.posY -= f1;
            }
            float f = this.renderCharAtPos(j, c0, this.italicStyle);
            if (flag1) {
                this.posX += f1;
                this.posY += f1;
            }
            if (this.boldStyle) {
                this.posX += f1;
                if (flag1) {
                    this.posX -= f1;
                    this.posY -= f1;
                }
                this.renderCharAtPos(j, c0, this.italicStyle);
                this.posX -= f1;
                if (flag1) {
                    this.posX += f1;
                    this.posY += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f);
        }
    }

    protected void doDraw(float f) {
        Tessellator tessellator;
        if (this.strikethroughStyle) {
            tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(Minecraft.func_71410_x().field_71466_p.field_78288_b / 2)), 0.0);
            tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)(Minecraft.func_71410_x().field_71466_p.field_78288_b / 2)), 0.0);
            tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)(Minecraft.func_71410_x().field_71466_p.field_78288_b / 2) - 1.0f), 0.0);
            tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(Minecraft.func_71410_x().field_71466_p.field_78288_b / 2) - 1.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        if (this.underlineStyle) {
            tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int l = this.underlineStyle ? -1 : 0;
            tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)Minecraft.func_71410_x().field_71466_p.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)Minecraft.func_71410_x().field_71466_p.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)Minecraft.func_71410_x().field_71466_p.field_78288_b - 1.0f), 0.0);
            tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)Minecraft.func_71410_x().field_71466_p.field_78288_b - 1.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        this.posX += (float)((int)f);
    }

    private float renderCharAtPos(int p_78278_1_, char p_78278_2_, boolean p_78278_3_) {
        return p_78278_2_ == ' ' ? 4.0f : ("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(p_78278_2_) != -1 && !this.unicodeFlag ? this.renderDefaultChar(p_78278_1_, p_78278_3_) : this.renderUnicodeChar(p_78278_2_, p_78278_3_));
    }

    protected float renderDefaultChar(int p_78266_1_, boolean p_78266_2_) {
        float f = p_78266_1_ % 16 * 8;
        float f1 = p_78266_1_ / 16 * 8;
        float f2 = p_78266_2_ ? 1.0f : 0.0f;
        this.bindTexture(this.locationFontTexture);
        float f3 = (float)this.charWidth[p_78266_1_] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.charWidth[p_78266_1_];
    }

    private ResourceLocation getUnicodePageLocation(int p_111271_1_) {
        if (unicodePageLocations[p_111271_1_] == null) {
            OverlayQuestTracking.unicodePageLocations[p_111271_1_] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", p_111271_1_));
        }
        return unicodePageLocations[p_111271_1_];
    }

    private void loadGlyphTexture(int p_78257_1_) {
        this.bindTexture(this.getUnicodePageLocation(p_78257_1_));
    }

    protected float renderUnicodeChar(char p_78277_1_, boolean p_78277_2_) {
        if (this.glyphWidth[p_78277_1_] == 0) {
            return 0.0f;
        }
        int i = p_78277_1_ / 256;
        this.loadGlyphTexture(i);
        int j = this.glyphWidth[p_78277_1_] >>> 4;
        int k = this.glyphWidth[p_78277_1_] & 0xF;
        float f = j;
        float f1 = k + 1;
        float f2 = (float)(p_78277_1_ % 16 * 16) + f;
        float f3 = (p_78277_1_ & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        float f5 = p_78277_2_ ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - f) / 2.0f + 1.0f;
    }

    protected void setColor(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    protected void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }

    private void readFontTexture() {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(this.getResourceInputStream(this.locationFontTexture));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        int k = j / 16;
        int l = i / 16;
        int b0 = 1;
        float f = 8.0f / (float)l;
        for (int i1 = 0; i1 < 256; ++i1) {
            int l1;
            int j1 = i1 % 16;
            int k1 = i1 / 16;
            if (i1 == 32) {
                this.charWidth[i1] = 3 + b0;
            }
            for (l1 = l - 1; l1 >= 0; --l1) {
                int i2 = j1 * l + l1;
                boolean flag = true;
                for (int j2 = 0; j2 < k && flag; ++j2) {
                    int k2 = (k1 * l + j2) * i;
                    if ((aint[i2 + k2] >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            this.charWidth[i1] = (int)(0.5 + (double)((float)(++l1) * f)) + b0;
        }
    }

    private void readGlyphSizes() {
        try {
            InputStream inputstream = this.getResourceInputStream(new ResourceLocation("font/glyph_sizes.bin"));
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
    }

    protected InputStream getResourceInputStream(ResourceLocation location) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
    }

    private String bidiReorder(String p_147647_1_) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(p_147647_1_), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicshapingexception) {
            return p_147647_1_;
        }
    }
}

