/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import noppes.npcs.NPCSpawning;
import noppes.npcs.client.AnalyticsTracking;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.PlayerData;

public class ServerTickHandler {
    private String serverName = null;

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            NPCSpawning.findChunksForSpawning((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (this.serverName == null) {
            String e = "local";
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server.func_71262_S()) {
                try {
                    e = InetAddress.getByName(server.func_71211_k()).getCanonicalHostName();
                }
                catch (UnknownHostException e1) {
                    e = MinecraftServer.func_71276_C().func_71211_k();
                }
                if (server.func_71234_u() != 25565) {
                    e = e + ":" + server.func_71234_u();
                }
            }
            if (e == null || e.startsWith("192.168") || e.contains("127.0.0.1") || e.startsWith("localhost")) {
                e = "local";
            }
            this.serverName = e;
        }
        AnalyticsTracking.sendData(event.player, "join", this.serverName);
        PlayerData playerData = PlayerDataController.Instance.getPlayerData(event.player);
        if (playerData != null) {
            playerData.onLogin();
        }
        SyncController.syncPlayer(player);
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerData playerData = PlayerDataController.Instance.getPlayerData(event.player);
        if (playerData != null) {
            playerData.onLogout();
        }
    }
}

