/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.command;

import java.util.Collection;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.Server;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Party;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.util.ValueUtil;

public class QuestCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "quest";
    }

    @Override
    public String getDescription() {
        return "Quest operations";
    }

    @CommandKamkeelBase.SubCommand(desc="Start a quest", usage="<player> <quest>")
    public void start(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            QuestCommand.sendError(sender, "Unknown player: " + playername, new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID: " + questid, new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            QuestData questdata = new QuestData(quest);
            playerdata.questData.activeQuests.put(questid, questdata);
            playerdata.save();
            if (playerdata.player != null && questdata.sendAlerts) {
                Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
                Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
            }
            playerdata.updateClient = true;
            QuestCommand.sendResult(sender, String.format("Started Quest \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", questid, playerdata.playername), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Finish a quest", usage="<player> <quest>")
    public void finish(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            QuestCommand.sendError(sender, String.format("Unknown player '%s'", playername), new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID: " + questid, new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            if (playerdata.questData.activeQuests.containsKey(questid)) {
                playerdata.questData.activeQuests.remove(questid);
            }
            if (quest.repeat == EnumQuestRepeat.RLDAILY || quest.repeat == EnumQuestRepeat.RLWEEKLY) {
                playerdata.questData.finishedQuests.put(quest.id, System.currentTimeMillis());
            } else {
                playerdata.questData.finishedQuests.put(quest.id, sender.func_130014_f_().func_82737_E());
            }
            playerdata.save();
            if (playerdata.player != null) {
                Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.MESSAGE, "quest.completed", quest.title);
                Server.sendData((EntityPlayerMP)playerdata.player, EnumPacketClient.CHAT, "quest.completed", ": ", quest.title);
            }
            playerdata.updateClient = true;
            QuestCommand.sendResult(sender, String.format("Finished Quest \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", questid, playerdata.playername), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Stop a started quest", usage="<player> <quest>")
    public void stop(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            QuestCommand.sendError(sender, String.format("Unknown player '%s'", playername), new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID: " + questid, new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            playerdata.questData.activeQuests.remove(questid);
            playerdata.save();
            playerdata.updateClient = true;
            QuestCommand.sendResult(sender, String.format("Stopped Quest \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", questid, playerdata.playername), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a quest from finished and active quests", usage="<player> <quest>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        String playername = args[0];
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            QuestCommand.sendError(sender, String.format("Unknown player '%s'", playername), new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID", new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            playerdata.questData.activeQuests.remove(questid);
            playerdata.questData.finishedQuests.remove(questid);
            playerdata.save();
            playerdata.updateClient = true;
            QuestCommand.sendResult(sender, String.format("Removed Quest \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", questid, playerdata.playername), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Get/Set objectives for quests progress", usage="<player> <quest> [objective] [value]")
    public void objective(ICommandSender sender, String[] args) throws CommandException {
        int value;
        int objective;
        boolean partyValid;
        int questid;
        EntityPlayerMP player = CommandBase.func_82359_c((ICommandSender)sender, (String)args[0]);
        try {
            questid = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID", new Object[0]);
            return;
        }
        PlayerData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
        if (data == null) {
            QuestCommand.sendError(sender, "No PlayerData found for:" + player, new Object[0]);
            return;
        }
        Party party = data.getPlayerParty();
        boolean bl = partyValid = party != null && party.getQuest() != null && party.getQuest().getId() == quest.id;
        if (!partyValid && !data.questData.activeQuests.containsKey(quest.id)) {
            QuestCommand.sendError(sender, "Player does not have quest active", new Object[0]);
            return;
        }
        IQuestObjective[] objectives = partyValid ? quest.questInterface.getPartyObjectives(party) : quest.questInterface.getObjectives((EntityPlayer)player);
        if (args.length <= 2) {
            if (partyValid) {
                QuestCommand.sendResult(sender, "For Party: ", new Object[0]);
            }
            for (IQuestObjective ob : objectives) {
                QuestCommand.sendResult(sender, ob.getText(), new Object[0]);
            }
            return;
        }
        try {
            objective = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "Objective must be an integer. Most often 0, 1 or 2", new Object[0]);
            return;
        }
        if (objective < 0 || objective >= objectives.length) {
            QuestCommand.sendError(sender, "Invalid objective number was given", new Object[0]);
            return;
        }
        if (args.length <= 3) {
            QuestCommand.sendResult(sender, objectives[objective].getText(), new Object[0]);
            return;
        }
        IQuestObjective object = objectives[objective];
        String s = args[3];
        try {
            value = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "Value must be an integer", new Object[0]);
            return;
        }
        if (s.startsWith("-") || s.startsWith("+")) {
            value = ValueUtil.CorrectInt(object.getProgress() + value, 0, object.getMaxProgress());
        }
        if (partyValid) {
            object.setPlayerProgress(player.func_70005_c_(), value);
        } else {
            object.setProgress(value);
        }
        QuestCommand.sendResult(sender, "Successfully updated progress", new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Find quest id number by its name", usage="<questName>")
    public void id(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            QuestCommand.sendError(sender, "Please provide a name for the quest", new Object[0]);
            return;
        }
        String catName = String.join((CharSequence)" ", args).toLowerCase();
        Collection<Quest> quests = QuestController.Instance.quests.values();
        int count = 0;
        for (Quest quest : quests) {
            if (!quest.getName().toLowerCase().contains(catName)) continue;
            QuestCommand.sendResult(sender, String.format("Quest \u00a7e%d\u00a77 - \u00a7c'%s'", quest.id, quest.getName()), new Object[0]);
            ++count;
        }
        if (count == 0) {
            QuestCommand.sendResult(sender, String.format("No Quest found with name: \u00a7c'%s'", catName), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Find prerequisite quests for an id", usage="<questId>")
    public void prereq(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        if (args.length == 0) {
            QuestCommand.sendError(sender, "Please provide an id for the quest", new Object[0]);
            return;
        }
        try {
            questid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID", new Object[0]);
            return;
        }
        Collection<Quest> quests = QuestController.Instance.quests.values();
        QuestCommand.sendResult(sender, "Prerequisites:", new Object[0]);
        QuestCommand.sendResult(sender, "--------------------", new Object[0]);
        boolean foundOne = false;
        for (Quest allQuest : quests) {
            if (allQuest.nextQuestid != questid) continue;
            foundOne = true;
            QuestCommand.sendResult(sender, String.format("Quest %d: \u00a7a'%s'", allQuest.id, allQuest.title), new Object[0]);
        }
        if (!foundOne) {
            QuestCommand.sendResult(sender, String.format("No Prerequisites found for Quest \u00a7c%d", questid), new Object[0]);
        }
        QuestCommand.sendResult(sender, "--------------------", new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Quick info on a quest", usage="<questId>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        int questid;
        if (args.length == 0) {
            QuestCommand.sendError(sender, "Please provide an id for the quest", new Object[0]);
            return;
        }
        try {
            questid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            QuestCommand.sendError(sender, "QuestID must be an integer: " + args[1], new Object[0]);
            return;
        }
        Quest quest = QuestController.Instance.quests.get(questid);
        if (quest == null) {
            QuestCommand.sendError(sender, "Unknown QuestID", new Object[0]);
            return;
        }
        QuestCommand.sendResult(sender, "--------------------", new Object[0]);
        QuestCommand.sendResult(sender, String.format("\u00a7e%d\u00a77: \u00a7a%s", quest.id, quest.title), new Object[0]);
        QuestCommand.sendResult(sender, String.format("Category: \u00a7b%s", quest.category.getName()), new Object[0]);
        QuestCommand.sendResult(sender, String.format("Type: \u00a76%s", quest.type.toString()), new Object[0]);
        QuestCommand.sendResult(sender, String.format("Repeatable: \u00a76%s", quest.repeat.toString()), new Object[0]);
        QuestCommand.sendResult(sender, String.format("Complete: \u00a76%s", quest.completion.toString()), new Object[0]);
        if (quest.completion == EnumQuestCompletion.Npc) {
            QuestCommand.sendResult(sender, String.format("NPC: \u00a76%s", quest.completerNpc), new Object[0]);
        }
        if (quest.nextQuestid != -1) {
            QuestCommand.sendResult(sender, String.format("Next Quest ID: \u00a7c%d", quest.nextQuestid), new Object[0]);
        }
        QuestCommand.sendResult(sender, "--------------------", new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="reload quests from disk", permission=4)
    public void reload(ICommandSender sender, String[] args) {
        new QuestController().load();
        SyncController.syncAllQuests();
        QuestCommand.sendResult(sender, "Quests Reloaded", new Object[0]);
    }
}

