/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.narutomoves.extensions;

import br.dev.brunoxkk0.narutomoves.extensions.PlayerDataHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class WallJumpProperties
implements IExtendedEntityProperties {
    public static final String KEY = "narutomoves_wall_jump";
    public byte wallJump;
    public byte oldVelocity;
    public byte hover;
    public byte shift;
    public byte wallIsValid;
    public byte wallIsValidB;
    public byte level = 1;
    public byte state = 0;

    public static void register() {
        PlayerDataHandler.registerProperty(KEY, entity -> new WallJumpProperties());
    }

    public static WallJumpProperties getInstance(EntityPlayer player) {
        return (WallJumpProperties)player.getExtendedProperties(KEY);
    }

    public boolean wallStillValid() {
        boolean isValid;
        boolean bl = isValid = this.wallIsValid > 0;
        if (isValid) {
            this.wallIsValid = (byte)(this.wallIsValid - 1);
        }
        return isValid;
    }

    public boolean wallStillValidB() {
        boolean isValid;
        boolean bl = isValid = this.wallIsValidB > 0;
        if (isValid) {
            this.wallIsValidB = (byte)(this.wallIsValidB - 1);
        }
        return isValid;
    }

    public boolean sneakingTrigger(EntityPlayer player) {
        boolean currentState = player.func_70093_af();
        if (this.shift != (currentState ? (byte)1 : 0)) {
            this.shift = (byte)(currentState ? 1 : 0);
            return true;
        }
        return false;
    }

    public boolean readyToJump() {
        return this.wallJump == 0;
    }

    public void tick() {
        if (this.wallJump > 0) {
            this.wallJump = (byte)(this.wallJump - 1);
        }
    }

    public boolean isJumping() {
        return this.wallJump > 0;
    }

    public boolean isHovering() {
        if (this.hover > 0) {
            this.hover = (byte)(this.hover - 1);
        }
        return this.hover > 0;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74774_a("narutomoves_wall_jump_level", this.level);
        compound.func_74774_a("narutomoves_wall_jump_state", this.state);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("narutomoves_wall_jump_level")) {
            this.level = compound.func_74771_c("narutomoves_wall_jump_level");
        }
        if (compound.func_74764_b("narutomoves_wall_jump_state")) {
            this.state = compound.func_74771_c("narutomoves_wall_jump_state");
        }
    }

    public void init(Entity entity, World world) {
    }

    public String toString() {
        return "WallJumpProperties{wallJump=" + this.wallJump + ", oldVelocity=" + this.oldVelocity + ", hover=" + this.hover + ", shift=" + this.shift + ", wallIsValid=" + this.wallIsValid + ", level=" + this.level + ", state=" + this.state + '}';
    }
}

