/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.advancedtitles.client;

import br.dev.brunoxkk0.advancedtitles.client.AdvancedTitleManager;
import br.dev.brunoxkk0.advancedtitles.common.Alignment;
import br.dev.brunoxkk0.advancedtitles.common.Title;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class AdvancedTitlesGui
extends Gui {
    public static final int DEFAULT_PADDING = 10;
    public static final int DEFAULT_MARGIN = 10;
    private static final AdvancedTitlesGui instance = new AdvancedTitlesGui();

    public static void renderTitle(Title title, ScaledResolution scaledResolution) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        minecraft.field_71424_I.func_76320_a("advancedtitles_render");
        int maxSize = 0;
        for (String line : title.getLines()) {
            maxSize = Math.max(fontRenderer.func_78256_a(line), maxSize);
        }
        if (maxSize == 0) {
            return;
        }
        int lines = title.getLines().length;
        int rawHeight = fontRenderer.field_78288_b * lines + (lines - 1);
        int width = maxSize + 10;
        int height = rawHeight + 10;
        int x = 0;
        int y = 0;
        switch (title.getAlignment()) {
            case TOP_LEFT: {
                x = 10;
                y = 10;
                break;
            }
            case TOP_MIDDLE: {
                x = (scaledResolution.func_78326_a() - width) / 2;
                y = 10;
                break;
            }
            case TOP_RIGHT: {
                x = scaledResolution.func_78326_a() - width - 10;
                y = 10;
                break;
            }
            case MIDDLE_LEFT: {
                x = 10;
                y = (scaledResolution.func_78328_b() - height) / 2;
                break;
            }
            case MIDDLE: {
                x = (scaledResolution.func_78326_a() - width) / 2;
                y = (scaledResolution.func_78328_b() - height) / 2;
                break;
            }
            case MIDDLE_RIGHT: {
                x = scaledResolution.func_78326_a() - width - 10;
                y = (scaledResolution.func_78328_b() - height) / 2;
                break;
            }
            case BOTTOM_LEFT: {
                x = 10;
                y = scaledResolution.func_78328_b() - height - 10;
                break;
            }
            case BOTTOM_MIDDLE: {
                x = (scaledResolution.func_78326_a() - width) / 2;
                y = scaledResolution.func_78328_b() - height - 10;
                break;
            }
            case BOTTOM_RIGHT: {
                x = scaledResolution.func_78326_a() - width - 10;
                y = scaledResolution.func_78328_b() - height - 10;
            }
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        AdvancedTitlesGui.func_73734_a((int)x, (int)(y += title.getPaddingY()), (int)((x += title.getPaddingX()) + width), (int)(y + height), (int)-1441787888);
        if (title.getDuration() != -1) {
            float progress = Math.max(0.0f, Math.min(1.0f, (float)(System.currentTimeMillis() - title.getStart()) / (float)((long)title.getDuration() * 1000L)));
            int barWidth = (int)((float)width * progress);
            AdvancedTitlesGui.func_73734_a((int)x, (int)(y + height - 2), (int)(x + barWidth), (int)(y + height), (int)-16711681);
        }
        GL11.glEnable((int)3553);
        for (int i = 0; i < lines; ++i) {
            String line = title.getLines()[i];
            int textWidth = fontRenderer.func_78256_a(line);
            int textX = x + (width - textWidth) / 2;
            int textY = y + 5 + i * fontRenderer.field_78288_b;
            fontRenderer.func_78261_a(line, textX, textY, 0xFFFFFF);
        }
        GL11.glPopAttrib();
        minecraft.field_71424_I.func_76319_b();
    }

    private void render(ScaledResolution scaledResolution) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("advancedtitles");
        for (Alignment alignment : Alignment.values()) {
            Title title = AdvancedTitleManager.CURRENT_TITLES[alignment.getId()];
            if (title == null) continue;
            if (title.getDuration() != -1 && title.getStart() + (long)title.getDuration() * 1000L < System.currentTimeMillis()) {
                AdvancedTitleManager.CURRENT_TITLES[alignment.getId()] = null;
                continue;
            }
            AdvancedTitlesGui.renderTitle(title, scaledResolution);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            instance.render(event.resolution);
        }
    }

    public static AdvancedTitlesGui getInstance() {
        return instance;
    }
}

