/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.wardrobe;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import riskyken.armourersWorkshop.common.addons.ModAddon;
import riskyken.armourersWorkshop.common.addons.ModAddonManager;
import riskyken.armourersWorkshop.common.config.ConfigHandler;
import riskyken.armourersWorkshop.common.data.PlayerPointer;
import riskyken.armourersWorkshop.common.network.PacketHandler;
import riskyken.armourersWorkshop.common.network.messages.server.MessageServerPlayerLeftTrackingRange;
import riskyken.armourersWorkshop.common.skin.data.SkinPointer;
import riskyken.armourersWorkshop.common.skin.type.SkinTypeRegistry;
import riskyken.armourersWorkshop.common.wardrobe.EntityEquipmentData;
import riskyken.armourersWorkshop.common.wardrobe.ExPropsPlayerSkinData;
import riskyken.armourersWorkshop.utils.HolidayHelper;
import riskyken.armourersWorkshop.utils.SkinNBTHelper;

public final class EntityEquipmentDataManager {
    public static EntityEquipmentDataManager INSTANCE;

    public static void init() {
        INSTANCE = new EntityEquipmentDataManager();
    }

    public EntityEquipmentDataManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public boolean isRenderItem(ModAddon.ItemOverrideType type, Item item) {
        String itemName = Item.field_150901_e.func_148750_c((Object)item);
        if (itemName != null && !itemName.isEmpty()) {
            String overrideToFind = type.toString().toLowerCase() + ":" + itemName;
            return ModAddonManager.itemOverrides.contains(overrideToFind);
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER & event.type == TickEvent.Type.PLAYER & event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            ExPropsPlayerSkinData props = ExPropsPlayerSkinData.get(player);
            if (props == null) {
                return;
            }
            this.updateWeaponNBT(player, props);
        }
    }

    private void updateWeaponNBT(EntityPlayer player, ExPropsPlayerSkinData props) {
        InventoryPlayer inventory = player.field_71071_by;
        EntityEquipmentData equipmentData = props.getEquipmentData();
        ItemStack stack = inventory.func_70448_g();
        if (stack != null) {
            if (this.isRenderItem(ModAddon.ItemOverrideType.SWORD, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinSword, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinSword, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
            if (this.isRenderItem(ModAddon.ItemOverrideType.BOW, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinBow, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinBow, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
            if (this.isRenderItem(ModAddon.ItemOverrideType.PICKAXE, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinPickaxe, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinPickaxe, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
            if (this.isRenderItem(ModAddon.ItemOverrideType.AXE, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinAxe, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinAxe, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
            if (this.isRenderItem(ModAddon.ItemOverrideType.SHOVEL, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinShovel, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinShovel, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
            if (this.isRenderItem(ModAddon.ItemOverrideType.HOE, stack.func_77973_b())) {
                if (equipmentData.haveEquipment(SkinTypeRegistry.skinHoe, 0)) {
                    SkinNBTHelper.addSkinPointerToStack(stack, (SkinPointer)equipmentData.getSkinPointer(SkinTypeRegistry.skinHoe, 0));
                } else {
                    SkinNBTHelper.removeRenderIdFromStack(stack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityPlayerMP) {
            EntityPlayerMP targetPlayer = (EntityPlayerMP)event.target;
            ExPropsPlayerSkinData.get((EntityPlayer)event.entity).sendCustomArmourDataToPlayer(targetPlayer);
        }
    }

    @SubscribeEvent
    public void onStopTracking(PlayerEvent.StopTracking event) {
        if (event.target instanceof EntityPlayerMP) {
            EntityPlayerMP target = (EntityPlayerMP)event.target;
            MessageServerPlayerLeftTrackingRange message = new MessageServerPlayerLeftTrackingRange(new PlayerPointer((EntityPlayer)target));
            PacketHandler.networkWrapper.sendTo((IMessage)message, (EntityPlayerMP)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExPropsPlayerSkinData.get((EntityPlayer)event.entity) == null) {
            ExPropsPlayerSkinData.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayerMP) {
            ExPropsPlayerSkinData playerData = ExPropsPlayerSkinData.get((EntityPlayer)event.entity);
            playerData.sendCustomArmourDataToPlayer((EntityPlayerMP)event.entity);
            HolidayHelper.giftPlayer((EntityPlayerMP)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayerMP) {
            boolean dropSkins = true;
            GameRules gr = this.getGameRules();
            boolean keepInventory = false;
            if (gr.func_82765_e("keepInventory")) {
                keepInventory = gr.func_82766_b("keepInventory");
            }
            switch (ConfigHandler.dropSkinsOnDeath) {
                case 0: {
                    dropSkins = !keepInventory;
                    break;
                }
                case 1: {
                    dropSkins = false;
                    break;
                }
                case 2: {
                    dropSkins = true;
                    break;
                }
                default: {
                    dropSkins = !keepInventory;
                }
            }
            ExPropsPlayerSkinData playerData = ExPropsPlayerSkinData.get((EntityPlayer)event.entity);
            if (dropSkins) {
                playerData.getWardrobeInventoryContainer().dropItems((EntityPlayer)event.entity);
            }
        }
    }

    private GameRules getGameRules() {
        return MinecraftServer.func_71276_C().func_71218_a(0).func_82736_K();
    }

    @SubscribeEvent
    public void onLivingDeathEvent(PlayerEvent.Clone event) {
        NBTTagCompound compound = new NBTTagCompound();
        ExPropsPlayerSkinData oldProps = ExPropsPlayerSkinData.get(event.original);
        ExPropsPlayerSkinData newProps = ExPropsPlayerSkinData.get(event.entityPlayer);
        oldProps.saveNBTData(compound);
        newProps.loadNBTData(compound);
    }
}

