/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.dbcdata;

import JinRyuu.JRMCore.JRMCoreConfig;
import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.i.ExtendedPlayer;
import JinRyuu.JRMCore.server.config.dbc.JGConfigRaces;
import JinRyuu.JRMCore.server.config.dbc.JGConfigUltraInstinct;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.controllers.DBCEffectController;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.util.ValueUtil;

public class DBCDataStats {
    private final DBCData data;

    public DBCDataStats(DBCData dbcData) {
        this.data = dbcData;
    }

    public int[] getAllAttributes() {
        return new int[]{this.data.STR, this.data.DEX, this.data.CON, this.data.WIL, this.data.MND, this.data.SPI};
    }

    public int getFullAttribute(int attri) {
        boolean majin = JRMCoreH.StusEfcts((int)12, (String)this.data.StatusEffects);
        boolean fusion = JRMCoreH.StusEfcts((int)10, (String)this.data.StatusEffects) || JRMCoreH.StusEfcts((int)11, (String)this.data.StatusEffects);
        boolean legendary = JRMCoreH.StusEfcts((int)14, (String)this.data.StatusEffects);
        boolean kaioken = JRMCoreH.StusEfcts((int)5, (String)this.data.StatusEffects);
        boolean mystic = JRMCoreH.StusEfcts((int)13, (String)this.data.StatusEffects);
        boolean ui = JRMCoreH.StusEfcts((int)19, (String)this.data.StatusEffects);
        boolean GoD = JRMCoreH.StusEfcts((int)20, (String)this.data.StatusEffects);
        return JRMCoreH.getPlayerAttribute((EntityPlayer)this.data.player, (int[])this.getAllAttributes(), (int)attri, (int)this.data.State, (int)this.data.State2, (int)this.data.Race, (String)this.data.RacialSkills, (int)this.data.Release, (int)this.data.ArcReserve, (boolean)legendary, (boolean)majin, (boolean)kaioken, (boolean)mystic, (boolean)ui, (boolean)GoD, (int)this.data.Powertype, (String[])this.data.Skills.split(","), (boolean)fusion, (String)this.data.MajinAbsorptionData);
    }

    public int[] getAllFullAttributes() {
        boolean majin = JRMCoreH.StusEfcts((int)12, (String)this.data.StatusEffects);
        boolean fusion = JRMCoreH.StusEfcts((int)10, (String)this.data.StatusEffects) || JRMCoreH.StusEfcts((int)11, (String)this.data.StatusEffects);
        boolean legendary = JRMCoreH.StusEfcts((int)14, (String)this.data.StatusEffects);
        boolean kaioken = JRMCoreH.StusEfcts((int)5, (String)this.data.StatusEffects);
        boolean mystic = JRMCoreH.StusEfcts((int)13, (String)this.data.StatusEffects);
        boolean ui = JRMCoreH.StusEfcts((int)19, (String)this.data.StatusEffects);
        boolean GoD = JRMCoreH.StusEfcts((int)20, (String)this.data.StatusEffects);
        int[] a = new int[6];
        for (int i = 0; i <= 5; ++i) {
            a[i] = JRMCoreH.getPlayerAttribute((EntityPlayer)this.data.player, (int[])this.getAllAttributes(), (int)i, (int)this.data.State, (int)this.data.State2, (int)this.data.Race, (String)this.data.RacialSkills, (int)this.data.Release, (int)this.data.ArcReserve, (boolean)legendary, (boolean)majin, (boolean)kaioken, (boolean)mystic, (boolean)ui, (boolean)GoD, (int)this.data.Powertype, (String[])this.data.Skills.split(","), (boolean)fusion, (String)this.data.MajinAbsorptionData);
        }
        return a;
    }

    public int getExtraOutput(int att, int release) {
        int extraoutput = 0;
        if (att == 0) {
            int maxki = this.getMaxStat(5);
            extraoutput = (int)((double)JRMCoreH.SklLvl((int)12, (String[])this.data.Skills.split(",")) * 0.0025 * (double)maxki * (double)release * 0.01);
        } else if (att == 1) {
            int maxki = this.getMaxStat(5);
            extraoutput = (int)((double)JRMCoreH.SklLvl((int)11, (String[])this.data.Skills.split(",")) * 0.005 * (double)maxki * (double)release * 0.01);
        } else if (att == 5) {
            extraoutput = this.getMaxStat(5) - JRMCoreH.stat((Entity)this.data.player, (int)att, (int)this.data.Powertype, (int)att, (int)this.data.SPI, (int)this.data.Race, (int)this.data.Class, (float)JRMCoreH.SklLvl_KiBs((String[])this.data.Skills.split(","), (int)1));
        }
        return extraoutput;
    }

    public int getMaxStat(int attributeID) {
        int attribute = 0;
        attribute = attributeID == 0 || attributeID == 1 || attributeID == 4 ? this.getFullAttribute(attributeID) : this.getAllAttributes()[attributeID];
        float f = attributeID == 5 ? JRMCoreH.SklLvl_KiBs((String[])this.data.Skills.split(","), (int)1) : 0.0f;
        int stat = JRMCoreH.stat((Entity)this.data.player, (int)attributeID, (int)this.data.Powertype, (int)attributeID, (int)attribute, (int)this.data.Race, (int)this.data.Class, (float)f);
        if (attributeID == 0) {
            stat += this.getExtraOutput(attributeID, 100);
        } else if (attributeID == 1) {
            stat += this.getExtraOutput(attributeID, 100);
        }
        return stat;
    }

    public int getCurrentStat(int attribute) {
        float stat = (float)((double)this.getMaxStat(attribute) * ((double)this.data.Release * 0.01) * (double)JRMCoreH.weightPerc((int)0, (EntityPlayer)this.data.player));
        return stat > 2.1474836E9f ? Integer.MAX_VALUE : (int)stat;
    }

    public double getCurrentMulti() {
        return (double)this.getFullAttribute(0) / (double)this.data.STR;
    }

    public int getMaxBody() {
        return JRMCoreH.stat((Entity)this.data.player, (int)2, (int)this.data.Powertype, (int)2, (int)this.data.CON, (int)this.data.Race, (int)this.data.Class, (float)0.0f);
    }

    public int getMaxStamina() {
        return JRMCoreH.stat((Entity)this.data.player, (int)2, (int)this.data.Powertype, (int)3, (int)this.data.CON, (int)this.data.Race, (int)this.data.Class, (float)0.0f);
    }

    public int getMaxKi() {
        return JRMCoreH.stat((Entity)this.data.player, (int)5, (int)this.data.Powertype, (int)5, (int)this.data.SPI, (int)this.data.Race, (int)this.data.Class, (float)JRMCoreH.SklLvl_KiBs((String[])this.data.Skills.split(","), (int)1));
    }

    public int getMaxFusionBody() {
        EntityPlayer spectator;
        int con = this.data.CON;
        if (this.isFused() && (spectator = this.getSpectatorEntity()) != null) {
            DBCData specData = DBCData.get(spectator);
            con = Math.min(this.data.CON, specData.CON) * 2;
        }
        return JRMCoreH.stat((Entity)this.data.player, (int)2, (int)this.data.Powertype, (int)2, (int)con, (int)this.data.Race, (int)this.data.Class, (float)0.0f);
    }

    public int getMaxFusionStamina() {
        EntityPlayer spectator;
        int con = this.data.CON;
        if (this.isFused() && (spectator = this.getSpectatorEntity()) != null) {
            DBCData specData = DBCData.get(spectator);
            con = Math.min(this.data.CON, specData.CON) * 2;
        }
        return JRMCoreH.stat((Entity)this.data.player, (int)2, (int)this.data.Powertype, (int)3, (int)con, (int)this.data.Race, (int)this.data.Class, (float)0.0f);
    }

    public int getMaxFusionKi() {
        EntityPlayer spectator;
        int spi = this.data.SPI;
        if (this.isFused() && (spectator = this.getSpectatorEntity()) != null) {
            DBCData specData = DBCData.get(spectator);
            spi = Math.min(this.data.SPI, specData.SPI) * 2;
        }
        return JRMCoreH.stat((Entity)this.data.player, (int)5, (int)this.data.Powertype, (int)5, (int)spi, (int)this.data.Race, (int)this.data.Class, (float)JRMCoreH.SklLvl_KiBs((EntityPlayer)this.data.player, (int)1));
    }

    public float getCurrentBodyPercentage() {
        if (this.isFused()) {
            return (float)(this.data.Body * 100) / (float)this.getMaxFusionBody();
        }
        return (float)(this.data.Body * 100) / (float)this.getMaxBody();
    }

    public void restoreKiPercent(float percToRestore) {
        int maxKi = this.isFused() ? this.getMaxFusionKi() : this.getMaxKi();
        int toAdd = (int)((float)maxKi * (percToRestore / 100.0f));
        this.data.Ki = ValueUtil.clamp((int)(this.data.Ki + toAdd), (int)0, (int)maxKi);
        this.data.getRawCompound().func_74768_a("jrmcEnrgy", this.data.Ki);
    }

    public void restoreKiFlat(int amountToRestore) {
        int maxKi = this.isFused() ? this.getMaxFusionKi() : this.getMaxKi();
        this.data.Ki = ValueUtil.clamp((int)(this.data.Ki + amountToRestore), (int)0, (int)maxKi);
        this.data.getRawCompound().func_74768_a("jrmcEnrgy", this.data.Ki);
    }

    public void restoreHealthPercent(float percToRestore) {
        int maxBody = this.isFused() ? this.getMaxFusionBody() : this.getMaxBody();
        int toAdd = (int)((float)maxBody * (percToRestore / 100.0f));
        this.data.Body = ValueUtil.clamp((int)(this.data.Body + toAdd), (int)0, (int)maxBody);
        this.data.getRawCompound().func_74768_a("jrmcBdy", this.data.Body);
    }

    public void restoreStaminaPercent(float percToRestore) {
        int maxSta = this.isFused() ? this.getMaxFusionStamina() : this.getMaxStamina();
        int toAdd = (int)((float)maxSta * (percToRestore / 100.0f));
        this.data.Stamina = ValueUtil.clamp((int)(this.data.Stamina + toAdd), (int)0, (int)maxSta);
        this.data.getRawCompound().func_74768_a("jrmcStamina", this.data.Stamina);
    }

    public void restoreUIHeat(float percToRestore) {
        if (!this.data.isForm(41)) {
            return;
        }
        int maxHeat = JGConfigUltraInstinct.CONFIG_UI_HEAT_DURATION[this.data.State2];
        int toAdd = (int)((float)maxHeat * (percToRestore / 100.0f));
        this.data.Heat = ValueUtil.clamp((int)(this.data.Heat - toAdd), (int)0, (int)maxHeat);
        this.data.getRawCompound().func_74768_a("jrmcEf8slc", this.data.Heat);
    }

    public void setArcReserve(int reserve) {
        if (this.data.Race != 4) {
            return;
        }
        JRMCoreH.nbt((EntityPlayer)this.data.player).func_74768_a("jrmcArcRsrv", reserve);
    }

    public void restoreArcPP(int percToRestoreFromMax) {
        if (this.data.Race != 4) {
            return;
        }
        int maxReserve = JRMCoreConfig.ArcosianPPMax[this.getMaxSkillX()];
        int toAdd = maxReserve * (percToRestoreFromMax / 100);
        int reserve = Math.max(JRMCoreH.nbt((EntityPlayer)this.data.player).func_74762_e("jrmcArcRsrv"), 0);
        reserve = ValueUtil.clamp((int)(reserve + toAdd), (int)0, (int)maxReserve);
        this.setArcReserve(reserve);
    }

    public void setAbsorption(int amount) {
        if (this.data.Race != 5) {
            return;
        }
        JRMCoreH.nbt((EntityPlayer)this.data.player).func_74778_a("jrmcMajinAbsorptionData", amount + ",0,0+0");
    }

    public void restoreAbsorption(int percToRestoreFromMax) {
        if (this.data.Race != 5) {
            return;
        }
        int maxAbsorption = JGConfigRaces.CONFIG_MAJIN_ABSORPTON_MAX_LEVEL;
        int toAdd = (int)((float)maxAbsorption * ((float)percToRestoreFromMax / 100.0f));
        int currentAbsorption = JRMCoreH.getMajinAbsorptionValueS((String)JRMCoreH.nbt((EntityPlayer)this.data.player).func_74779_i("jrmcMajinAbsorptionData"));
        this.setAbsorption(ValueUtil.clamp((int)(toAdd + currentAbsorption), (int)0, (int)maxAbsorption));
    }

    public int getMaxSkillX() {
        String racial = JRMCoreH.nbt((EntityPlayer)this.data.player).func_74779_i("jrmcSSltX");
        if (racial == null || racial.isEmpty() || racial.contains("pty")) {
            return 0;
        }
        return Integer.parseInt(racial.substring(2));
    }

    public int getJRMCPlayerID() {
        try {
            for (int pl = 0; pl < JRMCoreH.plyrs.length; ++pl) {
                if (!JRMCoreH.plyrs[pl].equals(this.data.player.func_70005_c_())) continue;
                return pl;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public String getJRMCData(int id) {
        return JRMCoreH.data((int)id)[this.getJRMCPlayerID()];
    }

    public boolean isFused() {
        if (this.data.containsSE(10) || this.data.containsSE(11)) {
            return true;
        }
        if (this.data.Fusion.contains(",")) {
            String[] fusionMembers = this.data.Fusion.split(",");
            return fusionMembers.length == 3;
        }
        return false;
    }

    public boolean isFusionSpectator() {
        String[] fusionMembers;
        if (this.data.containsSE(11)) {
            return true;
        }
        if (this.data.Fusion.contains(",") && (fusionMembers = this.data.Fusion.split(",")).length == 3) {
            return fusionMembers[1].equalsIgnoreCase(this.data.player.func_70005_c_());
        }
        return false;
    }

    public String getSpectatorName() {
        String[] fusionMembers;
        if (this.data.Fusion.contains(",") && (fusionMembers = this.data.Fusion.split(",")).length == 3) {
            return fusionMembers[1];
        }
        return "";
    }

    public EntityPlayer getSpectatorEntity() {
        String spectator;
        if (this.isFused() && !this.isFusionSpectator() && !(spectator = this.getSpectatorName()).isEmpty()) {
            EntityPlayer specEntity = null;
            specEntity = this.data.player.field_70170_p.field_72995_K ? this.data.player.field_70170_p.func_72924_a(spectator) : NoppesUtilServer.getPlayerByName((String)spectator);
            return specEntity;
        }
        return null;
    }

    public boolean isChargingKiAttack() {
        ExtendedPlayer jrmcExtendedPlayer = ExtendedPlayer.get((EntityPlayer)this.data.player);
        boolean kiAnimationTypeSelected = jrmcExtendedPlayer.getAnimKiShoot() != 0;
        boolean shouldAttemptAnimation = jrmcExtendedPlayer.getAnimKiShootOn() != 0;
        return kiAnimationTypeSelected && shouldAttemptAnimation;
    }

    public void applyNamekianRegen() {
        if (this.data.player == null) {
            return;
        }
        if (this.getCurrentBodyPercentage() < (float)ConfigDBCGameplay.NamekianRegenMin && !DBCEffectController.getInstance().hasEffect(this.data.player, 4)) {
            DBCEffectController.getInstance().applyEffect(this.data.player, 4, -100);
        }
    }

    public byte getPotentialUnlockLevel() {
        return (byte)JRMCoreH.SklLvl((int)5, (String[])this.data.Skills.split(","));
    }

    public double getDBCMastery(int formID) {
        String formName = DBCForm.getJRMCName(formID, this.data.Race);
        if (formName == null) {
            return 0.0;
        }
        boolean isRacial = formID <= 15;
        String masteryData = isRacial ? this.data.FormMasteryRacial : this.data.FormMasteryNR;
        Pattern pattern = Pattern.compile(formName + ",([^;]*)");
        Matcher matcher = pattern.matcher(masteryData);
        if (matcher.find()) {
            return Double.parseDouble(matcher.group(1));
        }
        return 0.0;
    }

    public void setDBCMastery(int formID, double level) {
        String formName = DBCForm.getJRMCName(formID, this.data.Race);
        if (formName == null) {
            return;
        }
        boolean isRacial = formID <= 15;
        double maxMasteryLevel = DBCForm.getJRMCMaxFormLevel(formID, this.data.Race);
        if (maxMasteryLevel == -1.0) {
            return;
        }
        String masteryData = isRacial ? this.data.FormMasteryRacial : this.data.FormMasteryNR;
        level = ValueUtil.clamp((double)level, (double)0.0, (double)maxMasteryLevel);
        if (masteryData.contains(formName)) {
            masteryData = masteryData.replaceAll("(" + formName + ",)[^;]*", "$1" + level);
        } else {
            String formData = formName + "," + level;
            masteryData = masteryData + (masteryData.endsWith(";") ? formData : ";" + formData);
        }
        this.updateMastery(masteryData, isRacial);
    }

    public void addDBCMastery(int formID, float level) {
        this.setDBCMastery(formID, this.getDBCMastery(formID) + (double)level);
    }

    private void updateMastery(String newMastery, boolean isRacial) {
        if (isRacial) {
            this.data.FormMasteryRacial = newMastery;
            this.data.getRawCompound().func_74778_a("jrmcFormMasteryRacial_" + JRMCoreH.Races[this.data.Race], newMastery);
        } else {
            this.data.FormMasteryNR = newMastery;
            this.data.getRawCompound().func_74778_a("jrmcFormMasteryNonRacial", newMastery);
        }
    }
}

