/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.attribute;

import java.util.Map;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.attribute.requirements.DBCClassRequirement;
import kamkeel.npcdbc.data.attribute.requirements.DBCLevelRequirement;
import kamkeel.npcdbc.data.attribute.requirements.DBCRaceRequirement;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormAttributes;
import kamkeel.npcs.controllers.AttributeController;
import kamkeel.npcs.controllers.data.attribute.AttributeDefinition;
import kamkeel.npcs.controllers.data.attribute.AttributeValueType;
import kamkeel.npcs.controllers.data.attribute.PlayerAttribute;
import kamkeel.npcs.controllers.data.attribute.requirement.IRequirementChecker;
import kamkeel.npcs.controllers.data.attribute.requirement.RequirementCheckerRegistry;
import kamkeel.npcs.controllers.data.attribute.tracker.AttributeRecalcEvent;
import kamkeel.npcs.controllers.data.attribute.tracker.PlayerAttributeTracker;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.config.ConfigMain;

public class DBCItemAttributes {
    public static String gearFlat = "GearFlat";
    public static String gearMulti = "GearMulti";
    public String strengthKey = "dbc.Strength";
    public String dexterityKey = "dbc.Dexterity";
    public String constitutionKey = "dbc.Constitution";
    public String willpowerKey = "dbc.WillPower";
    public String spiritKey = "dbc.Spirit";
    public String strengthMultiKey = "dbc.Strength.Multi";
    public String dexterityMultiKey = "dbc.Dexterity.Multi";
    public String constitutionMultiKey = "dbc.Constitution.Multi";
    public String willpowerMultiKey = "dbc.WillPower.Multi";
    public String spiritMultiKey = "dbc.Spirit.Multi";
    public static AttributeDefinition STRENGTH;
    public static AttributeDefinition DEXTERITY;
    public static AttributeDefinition CONSTITUTION;
    public static AttributeDefinition WILLPOWER;
    public static AttributeDefinition SPIRIT;
    public static AttributeDefinition STRENGTH_BOOST;
    public static AttributeDefinition DEXTERITY_BOOST;
    public static AttributeDefinition CONSTITUTION_BOOST;
    public static AttributeDefinition WILLPOWER_BOOST;
    public static AttributeDefinition SPIRIT_BOOST;

    public DBCItemAttributes() {
        STRENGTH = new AttributeDefinition(this.strengthKey, "Strength", '4', AttributeValueType.FLAT, AttributeDefinition.AttributeSection.STATS);
        STRENGTH.setTranslationKey("jinryuujrmcore.Strength");
        DEXTERITY = new AttributeDefinition(this.dexterityKey, "Dexterity", '6', AttributeValueType.FLAT, AttributeDefinition.AttributeSection.STATS);
        DEXTERITY.setTranslationKey("jinryuujrmcore.Dexterity");
        CONSTITUTION = new AttributeDefinition(this.constitutionKey, "Constitution", 'b', AttributeValueType.FLAT, AttributeDefinition.AttributeSection.STATS);
        CONSTITUTION.setTranslationKey("jinryuujrmcore.Constitution");
        WILLPOWER = new AttributeDefinition(this.willpowerKey, "Willpower", 'd', AttributeValueType.FLAT, AttributeDefinition.AttributeSection.STATS);
        WILLPOWER.setTranslationKey("jinryuujrmcore.WillPower");
        SPIRIT = new AttributeDefinition(this.spiritKey, "Spirit", '3', AttributeValueType.FLAT, AttributeDefinition.AttributeSection.STATS);
        SPIRIT.setTranslationKey("jinryuujrmcore.Spirit");
        STRENGTH_BOOST = new AttributeDefinition(this.strengthMultiKey, "Strength Multi", '4', AttributeValueType.PERCENT, AttributeDefinition.AttributeSection.STATS);
        STRENGTH_BOOST.setTranslationKey("jinryuujrmcore.Strength");
        DEXTERITY_BOOST = new AttributeDefinition(this.dexterityMultiKey, "Dexterity Multi", '6', AttributeValueType.PERCENT, AttributeDefinition.AttributeSection.STATS);
        DEXTERITY_BOOST.setTranslationKey("jinryuujrmcore.Dexterity");
        CONSTITUTION_BOOST = new AttributeDefinition(this.constitutionMultiKey, "Constitution Multi", 'b', AttributeValueType.PERCENT, AttributeDefinition.AttributeSection.STATS);
        CONSTITUTION_BOOST.setTranslationKey("jinryuujrmcore.Constitution");
        WILLPOWER_BOOST = new AttributeDefinition(this.willpowerMultiKey, "Willpower Multi", 'd', AttributeValueType.PERCENT, AttributeDefinition.AttributeSection.STATS);
        WILLPOWER_BOOST.setTranslationKey("jinryuujrmcore.WillPower");
        SPIRIT_BOOST = new AttributeDefinition(this.spiritMultiKey, "Spirit Multi", '3', AttributeValueType.PERCENT, AttributeDefinition.AttributeSection.STATS);
        SPIRIT_BOOST.setTranslationKey("jinryuujrmcore.Spirit");
        AttributeController.registerAttribute((AttributeDefinition)STRENGTH);
        AttributeController.registerAttribute((AttributeDefinition)DEXTERITY);
        AttributeController.registerAttribute((AttributeDefinition)CONSTITUTION);
        AttributeController.registerAttribute((AttributeDefinition)WILLPOWER);
        AttributeController.registerAttribute((AttributeDefinition)SPIRIT);
        AttributeController.registerAttribute((AttributeDefinition)STRENGTH_BOOST);
        AttributeController.registerAttribute((AttributeDefinition)DEXTERITY_BOOST);
        AttributeController.registerAttribute((AttributeDefinition)CONSTITUTION_BOOST);
        AttributeController.registerAttribute((AttributeDefinition)WILLPOWER_BOOST);
        AttributeController.registerAttribute((AttributeDefinition)SPIRIT_BOOST);
        AttributeRecalcEvent.registerPreListener((entityPlayer, playerAttributeTracker) -> DBCItemAttributes.preListener(entityPlayer, playerAttributeTracker));
        AttributeRecalcEvent.registerListener((entityPlayer, playerAttributeTracker) -> DBCItemAttributes.postListener(entityPlayer, playerAttributeTracker));
        RequirementCheckerRegistry.registerChecker((IRequirementChecker)new DBCLevelRequirement());
        RequirementCheckerRegistry.registerChecker((IRequirementChecker)new DBCRaceRequirement());
        RequirementCheckerRegistry.registerChecker((IRequirementChecker)new DBCClassRequirement());
    }

    public static void preListener(EntityPlayer player, PlayerAttributeTracker tracker) {
        if (ConfigMain.AttributesEnabled) {
            Form form = DBCData.get(player).getForm();
            if (form == null) {
                return;
            }
            FormAttributes fa = form.customAttributes;
            for (Map.Entry<String, Float> entry : fa.getAllAttributes().entrySet()) {
                AttributeDefinition def = AttributeController.getAttribute((String)entry.getKey());
                if (def == null) continue;
                PlayerAttribute inst = tracker.playerAttributes.getAttributeInstance(def);
                if (inst == null) {
                    inst = tracker.playerAttributes.registerAttribute(def, 0.0f);
                }
                inst.value += entry.getValue().floatValue();
            }
            for (Map.Entry<String, Object> entry : fa.getAllMagic().entrySet()) {
                String tag = entry.getKey();
                ((Map)entry.getValue()).forEach((magicId, v) -> {
                    switch (tag) {
                        case "magic_damage": {
                            tracker.magicDamage.merge(magicId, v, Float::sum);
                            break;
                        }
                        case "magic_boost": {
                            tracker.magicBoost.merge(magicId, v, Float::sum);
                            break;
                        }
                        case "magic_defense": {
                            tracker.magicDefense.merge(magicId, v, Float::sum);
                            break;
                        }
                        case "magic_resistance": {
                            tracker.magicResistance.merge(magicId, v, Float::sum);
                        }
                    }
                });
            }
        }
    }

    public static void postListener(EntityPlayer entityPlayer, PlayerAttributeTracker playerAttributeTracker) {
        BonusController.getInstance().removeBonus(entityPlayer, gearFlat);
        BonusController.getInstance().removeBonus(entityPlayer, gearMulti);
        if (ConfigMain.AttributesEnabled) {
            boolean hasMultiBonus;
            PlayerBonus flatBonus = new PlayerBonus(gearFlat, 1);
            flatBonus.setStrength(playerAttributeTracker.getAttributeValue(STRENGTH));
            flatBonus.setDexterity(playerAttributeTracker.getAttributeValue(DEXTERITY));
            flatBonus.setConstitution(playerAttributeTracker.getAttributeValue(CONSTITUTION));
            flatBonus.setWillpower(playerAttributeTracker.getAttributeValue(WILLPOWER));
            flatBonus.setSpirit(playerAttributeTracker.getAttributeValue(SPIRIT));
            PlayerBonus multiBonus = new PlayerBonus(gearMulti, 0);
            multiBonus.setStrength(playerAttributeTracker.getAttributeValue(STRENGTH_BOOST) / 100.0f);
            multiBonus.setDexterity(playerAttributeTracker.getAttributeValue(DEXTERITY_BOOST) / 100.0f);
            multiBonus.setConstitution(playerAttributeTracker.getAttributeValue(CONSTITUTION_BOOST) / 100.0f);
            multiBonus.setWillpower(playerAttributeTracker.getAttributeValue(WILLPOWER_BOOST) / 100.0f);
            multiBonus.setSpirit(playerAttributeTracker.getAttributeValue(SPIRIT_BOOST) / 100.0f);
            boolean hasFlatBonus = flatBonus.getStrength() != 0.0f || flatBonus.getDexterity() != 0.0f || flatBonus.getConstitution() != 0.0f || flatBonus.getWillpower() != 0.0f || flatBonus.getSpirit() != 0.0f;
            boolean bl = hasMultiBonus = multiBonus.getStrength() != 0.0f || multiBonus.getDexterity() != 0.0f || multiBonus.getConstitution() != 0.0f || multiBonus.getWillpower() != 0.0f || multiBonus.getSpirit() != 0.0f;
            if (hasFlatBonus) {
                BonusController.getInstance().applyBonus(entityPlayer, flatBonus);
            }
            if (hasMultiBonus) {
                BonusController.getInstance().applyBonus(entityPlayer, multiBonus);
            }
        }
    }
}

