/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.aura.IAuraHandler;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.packets.get.DBCInfoSyncPacket;
import kamkeel.npcs.network.enums.EnumSyncAction;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.util.NBTJsonUtil;

public class AuraController
implements IAuraHandler {
    public static AuraController Instance = new AuraController();
    public HashMap<Integer, Aura> customAurasSync = new HashMap();
    public HashMap<Integer, Aura> customAuras;
    private HashMap<Integer, String> bootOrder;
    private int lastUsedID = 0;

    public AuraController() {
        Instance = this;
        this.customAuras = new HashMap();
        this.bootOrder = new HashMap();
    }

    public void load() {
        this.customAuras = new HashMap();
        this.bootOrder = new HashMap();
        this.lastUsedID = 0;
        LogWriter.info((Object)"Loading custom auras...");
        this.readCustomAuraMap();
        this.loadAuras();
        LogWriter.info((Object)"Done loading custom auras.");
    }

    public IAura createAura(String name) {
        if (this.hasName(name)) {
            return this.get(name);
        }
        Aura aura = new Aura();
        aura.name = name;
        if (aura.id == -1) {
            aura.id = this.getUnusedId();
        }
        int setID = aura.id;
        while (!(!this.bootOrder.containsKey(setID) && !this.customAuras.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(aura.name))) {
            ++setID;
        }
        this.customAuras.put(aura.id, aura);
        aura.save();
        return aura;
    }

    @Override
    public IAura saveAura(IAura customAura) {
        if (customAura.getID() < 0) {
            customAura.setID(this.getUnusedId());
            while (this.hasName(customAura.getName())) {
                customAura.setName(customAura.getName() + "_");
            }
        } else {
            Aura existing = this.customAuras.get(customAura.getID());
            if (existing != null && !existing.name.equals(customAura.getName())) {
                while (this.hasName(customAura.getName())) {
                    customAura.setName(customAura.getName() + "_");
                }
            }
        }
        this.customAuras.remove(customAura.getID());
        this.customAuras.put(customAura.getID(), (Aura)customAura);
        this.saveAuraLoadMap();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, customAura.getName() + ".json_new");
        File file2 = new File(dir, customAura.getName() + ".json");
        try {
            NBTTagCompound nbtTagCompound = ((Aura)customAura).writeToNBT();
            NBTJsonUtil.SaveFile((File)file, (NBTTagCompound)nbtTagCompound);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            DBCPacketHandler.Instance.sendToAll(new DBCInfoSyncPacket(2, EnumSyncAction.UPDATE, -1, nbtTagCompound));
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
        return this.customAuras.get(customAura.getID());
    }

    public void deleteAuraFile(String name) {
        File file2;
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file2 = new File(dir, name + ".json")).exists()) {
            file2.delete();
        }
    }

    private void loadAuras() {
        this.customAuras.clear();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try {
                    Aura aura = new Aura();
                    aura.readFromNBT(NBTJsonUtil.LoadFile((File)file));
                    aura.name = file.getName().substring(0, file.getName().length() - 5);
                    if (aura.id == -1) {
                        aura.id = this.getUnusedId();
                    }
                    int originalID = aura.id;
                    int setID = aura.id;
                    while (!(!this.bootOrder.containsKey(setID) && !this.customAuras.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(aura.name))) {
                        ++setID;
                    }
                    aura.id = setID;
                    if (originalID != setID) {
                        LogWriter.info((Object)("Found Custom Aura ID Mismatch: " + aura.name + ", New ID: " + setID));
                        aura.save();
                    }
                    this.customAuras.put(aura.id, aura);
                }
                catch (Exception e) {
                    LogWriter.error((Object)("Error loading: " + file.getAbsolutePath()), (Exception)e);
                }
            }
        }
        this.saveAuraLoadMap();
    }

    public boolean hasName(String newName) {
        if (newName.trim().isEmpty()) {
            return true;
        }
        for (Aura aura : this.customAuras.values()) {
            if (!aura.name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAura get(String name) {
        return this.getAuraFromName(name);
    }

    @Override
    public IAura get(int id) {
        return this.customAuras.get(id);
    }

    @Override
    public boolean has(String name) {
        return this.getAuraFromName(name) != null;
    }

    public boolean has(int id) {
        return this.get(id) != null;
    }

    @Override
    public void delete(int id) {
        if (!this.customAuras.containsKey(id)) {
            return;
        }
        Aura foundAura = this.customAuras.remove(id);
        if (foundAura != null && foundAura.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundAura.name + ".json")) continue;
                file.delete();
                DBCPacketHandler.Instance.sendToAll(new DBCInfoSyncPacket(2, EnumSyncAction.REMOVE, foundAura.getID(), new NBTTagCompound()));
                break;
            }
            this.saveAuraLoadMap();
        }
    }

    @Override
    public void delete(String name) {
        Aura foundAura;
        Aura delete = this.getAuraFromName(name);
        if (delete != null && (foundAura = this.customAuras.remove(delete.getID())) != null && foundAura.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundAura.name + ".json")) continue;
                file.delete();
                DBCPacketHandler.Instance.sendToAll(new DBCInfoSyncPacket(2, EnumSyncAction.REMOVE, foundAura.getID(), new NBTTagCompound()));
                break;
            }
            this.saveAuraLoadMap();
        }
    }

    private File getDir() {
        return new File(CustomNpcs.getWorldSaveDirectory(), "customauras");
    }

    public int getUnusedId() {
        for (int catid : this.customAuras.keySet()) {
            if (catid <= this.lastUsedID) continue;
            this.lastUsedID = catid;
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    public String[] getNames() {
        String[] names = new String[this.customAuras.size()];
        int i = 0;
        for (Aura aura : this.customAuras.values()) {
            names[i] = aura.name.toLowerCase();
            ++i;
        }
        return names;
    }

    @Override
    public IAura[] getAuras() {
        ArrayList<Aura> auras = new ArrayList<Aura>(this.customAuras.values());
        return auras.toArray(new IAura[0]);
    }

    public Aura getAuraFromName(String auraName) {
        for (Map.Entry<Integer, Aura> entryAura : this.customAuras.entrySet()) {
            if (!entryAura.getValue().name.equalsIgnoreCase(auraName)) continue;
            return entryAura.getValue();
        }
        return null;
    }

    public File getMapDir() {
        File dir = CustomNpcs.getWorldSaveDirectory();
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void readCustomAuraMap() {
        this.bootOrder.clear();
        try {
            File file = new File(this.getMapDir(), "customauras.dat");
            if (file.exists()) {
                this.loadCustomAuraMap(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(this.getMapDir(), "customauras.dat_old");
                if (file.exists()) {
                    this.loadCustomAuraMap(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readCustomAuraMap(DataInputStream stream) throws IOException {
        NBTTagCompound nbtCompound = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.readMapNBT(nbtCompound);
    }

    private void loadCustomAuraMap(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.readCustomAuraMap(var1);
        var1.close();
    }

    public void readMapNBT(NBTTagCompound compound) {
        this.lastUsedID = compound.func_74762_e("lastID");
        NBTTagList list = compound.func_150295_c("CustomAuras", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                String auraName = nbttagcompound.func_74779_i("Name");
                Integer key = nbttagcompound.func_74762_e("ID");
                this.bootOrder.put(key, auraName);
            }
        }
    }

    public NBTTagCompound writeMapNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList auraList = new NBTTagList();
        for (Integer key : this.customAuras.keySet()) {
            Aura aura = this.customAuras.get(key);
            if (aura.getName().isEmpty()) continue;
            NBTTagCompound auraCompound = new NBTTagCompound();
            auraCompound.func_74778_a("Name", aura.getName());
            auraCompound.func_74768_a("ID", key.intValue());
            auraList.func_74742_a((NBTBase)auraCompound);
        }
        nbt.func_74782_a("CustomAuras", (NBTBase)auraList);
        nbt.func_74768_a("lastID", this.lastUsedID);
        return nbt;
    }

    public void saveAuraLoadMap() {
        try {
            File saveDir = this.getMapDir();
            File file = new File(saveDir, "customauras.dat_new");
            File file1 = new File(saveDir, "customauras.dat_old");
            File file2 = new File(saveDir, "customauras.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeMapNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
    }

    public static AuraController getInstance() {
        return Instance;
    }
}

