/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.narutomoves.core;

import br.dev.brunoxkk0.narutomoves.NarutoMoves;
import br.dev.brunoxkk0.narutomoves.extensions.WallJumpProperties;
import br.dev.brunoxkk0.narutomoves.network.messages.StaminaCostMessage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;

public class WallJumpHandler {
    public static AtomicBoolean request = new AtomicBoolean(false);
    public static AtomicBoolean waiting = new AtomicBoolean(false);
    public static AtomicBoolean back = new AtomicBoolean(false);

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        EntityPlayer player = event.player;
        boolean backwards = false;
        WallJumpProperties wallJumpProperties = WallJumpProperties.getInstance(player);
        wallJumpProperties.tick();
        if (!waiting.get() && wallJumpProperties.wallJump == -1) {
            wallJumpProperties.wallJump = 0;
        }
        if (wallJumpProperties.sneakingTrigger(player) && (this.checkWallInFront(player, wallJumpProperties) || (backwards = this.checkWallAtBack(player, wallJumpProperties))) && wallJumpProperties.readyToJump()) {
            this.requestJump();
            wallJumpProperties.wallJump = (byte)-1;
            waiting.set(true);
            back.set(backwards);
        }
        if (request.getAndSet(false)) {
            this.performWallJump(player, back.get());
        }
        if (wallJumpProperties.isJumping() && (this.checkWallInFront(player, wallJumpProperties) || this.checkWallAtBack(player, wallJumpProperties))) {
            wallJumpProperties.hover = (byte)50;
        }
        if (wallJumpProperties.isHovering() && !wallJumpProperties.isJumping() && (this.checkWallInFront(player, wallJumpProperties) || this.checkWallAtBack(player, wallJumpProperties))) {
            event.player.field_70181_x = 0.0;
            event.player.field_70159_w = 0.0;
            event.player.field_70179_y = 0.0;
            event.player.field_70143_R = 0.0f;
        }
    }

    private void requestJump() {
        NarutoMoves.DISPATCHER.sendToServer((IMessage)new StaminaCostMessage());
    }

    private boolean checkWallInFront(EntityPlayer player, WallJumpProperties wallJumpProperties) {
        boolean isValid;
        int blockZ;
        int blockY;
        if (wallJumpProperties.wallStillValid()) {
            return true;
        }
        float yaw = player.field_70177_z;
        double radians = Math.toRadians(yaw);
        double frontX = -Math.sin(radians);
        double frontZ = Math.cos(radians);
        double checkX = player.field_70165_t + frontX * 0.5;
        double checkY = player.field_70163_u;
        double checkZ = player.field_70161_v + frontZ * 0.5;
        int blockX = (int)Math.floor(checkX);
        Block block = player.field_70170_p.func_147439_a(blockX, blockY = (int)Math.floor(checkY), blockZ = (int)Math.floor(checkZ));
        boolean bl = isValid = block != null && !block.isAir((IBlockAccess)player.field_70170_p, blockX, blockY, blockZ);
        if (isValid) {
            wallJumpProperties.wallIsValid = (byte)10;
        }
        return isValid;
    }

    private boolean checkWallAtBack(EntityPlayer player, WallJumpProperties wallJumpProperties) {
        boolean isValid;
        int blockZ;
        int blockY;
        if (wallJumpProperties.wallStillValidB()) {
            return true;
        }
        float yaw = player.field_70177_z;
        double radians = Math.toRadians(yaw);
        double frontX = Math.sin(radians);
        double frontZ = -Math.cos(radians);
        double checkX = player.field_70165_t + frontX * 0.5;
        double checkY = player.field_70163_u;
        double checkZ = player.field_70161_v + frontZ * 0.5;
        int blockX = (int)Math.floor(checkX);
        Block block = player.field_70170_p.func_147439_a(blockX, blockY = (int)Math.floor(checkY), blockZ = (int)Math.floor(checkZ));
        boolean bl = isValid = block != null && !block.isAir((IBlockAccess)player.field_70170_p, blockX, blockY, blockZ);
        if (isValid) {
            wallJumpProperties.wallIsValidB = (byte)10;
        }
        return isValid;
    }

    private void performWallJump(EntityPlayer player, boolean back) {
        WallJumpProperties wallJumpProperties = WallJumpProperties.getInstance(player);
        wallJumpProperties.hover = 0;
        float yaw = player.field_70177_z;
        double radians = Math.toRadians(yaw);
        double dirX = -Math.sin(radians);
        double dirZ = Math.cos(radians);
        if (back) {
            dirX = -dirX;
            dirZ = -dirZ;
        }
        double knockbackX = -dirX * 0.8;
        double knockbackZ = -dirZ * 0.8;
        player.field_70159_w += knockbackX;
        player.field_70179_y += knockbackZ;
        player.field_70181_x = 0.8;
        wallJumpProperties.wallJump = (byte)10;
        player.func_85030_a("narutomoves:naruto.jump", 1.0f, 1.0f);
        player.field_70170_p.func_72869_a("cloud", player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0);
    }
}

