/*
 * Decompiled with CFR 0.152.
 */
package DamageIndicatorsMod.configuration;

import java.awt.RenderingHints;
import java.io.File;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DIConfig {
    public final File CONFIG_FILE;
    public float Size = 3.0f;
    public float Gravity = 0.8f;
    public float BounceStrength = 1.5f;
    public float ScaleFilter = 0.0f;
    public float transparency = 1.0f;
    public float guiScale = 0.76f;
    public int DIColor = 0xFFAA00;
    public int Lifespan = 12;
    public boolean CustomFont = true;
    public int packetrange = 30;
    public RenderingHints hints;
    public boolean alwaysRender = false;
    public boolean portraitEnabled = true;
    public boolean popOffsEnabled = true;
    public boolean enablePotionEffects = true;
    public int mouseoverRange = 30;
    public int healColor = 65280;
    public int portraitLifetime = 160;
    public int locX = 15;
    public int locY = 15;
    public boolean lockPosition = true;
    private String formattedDIColor = "FFAA00";
    private String formattedHealColor = "00FF00";
    public byte checkForUpdates = (byte)2;
    public boolean DebugHidesWindow = true;
    public String selectedSkin = "/assets/defaultskins/default/";
    public boolean alternateRenderingMethod = false;
    public boolean highCompatibilityMod = false;
    public boolean supressBossUI = false;
    public boolean showCriticalStrikes = true;
    public boolean useDropShadows = true;
    private static DIConfig diConfig;

    private DIConfig(File file, int check) {
        this.CONFIG_FILE = file;
        this.hints = this.populateHints();
        if (check == 1) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        } else {
            this.loadConfig();
        }
    }

    public static void loadConfig(File file) {
        diConfig = file == null ? new DIConfig(DIConfig.mainInstance().CONFIG_FILE, 0) : new DIConfig(file, 0);
    }

    public static DIConfig useNewConfig(DIConfig newConfig) {
        diConfig = newConfig;
        return DIConfig.mainInstance();
    }

    public static void overrideConfigAndSave(DIConfig newConfig) {
        try {
            Configuration config = new Configuration(newConfig.CONFIG_FILE);
            config.load();
            config.addCustomCategoryComment("PopOffs", "These Settings effect the digits that bounce off mobs when they take damage.");
            config.addCustomCategoryComment("Portrait", "These Settings effect the current health portrait window on the hud.");
            config.addCustomCategoryComment("PopOffs.Behavior", "This subcategory holds behavioral settings to do with PopOffs.");
            config.addCustomCategoryComment("Portrait.Behavior", "This subcategory holds behavioral settings to do with Portraits.");
            config.addCustomCategoryComment("PopOffs.Appearance", "This subcategory holds appearance settings to do with PopOffs.");
            config.addCustomCategoryComment("Portrait.Appearance", "This subcategory holds appearance settings to do with Portraits.");
            config.addCustomCategoryComment("Internal", "Don't Modify these settings unless explicitly told to or if you know what you are doing.\n This could result in the lose of settings or an unexpected crash.");
            Property prop = config.get("PopOffs.Behavior", "Lifespan", newConfig.Lifespan);
            prop.comment = "How long the damage indicator lasts before disappearing. Defaults to 12. Decimals not accepted, whole numbers only.";
            prop.set(newConfig.Lifespan);
            prop = config.get("Portrait.Appearance", "Portrait_xPos", newConfig.locX);
            prop.comment = "This is typically set from the repositioning Gui in game, but added here for modpacks.";
            prop.set(newConfig.locX);
            prop = config.get("Portrait.Appearance", "Portrait_Skin", newConfig.selectedSkin);
            prop.comment = "The Currently Selected Skin Path.";
            prop.set(newConfig.selectedSkin);
            prop = config.get("Portrait.Appearance", "Portrait_yPos", newConfig.locY);
            prop.comment = "This is typically set from the repositioning Gui in game, but added here for modpacks.";
            prop.set(newConfig.locY);
            prop = config.get("PopOffs.Appearance", "Always_Render", newConfig.alwaysRender);
            prop.comment = "When true, the particles will always render in front, otherwise, only if you can directly see the mob.";
            prop.set(newConfig.alwaysRender);
            prop = config.get("PopOffs.Behavior", "UpdateBehavior", (int)newConfig.checkForUpdates);
            prop.comment = "0 = Disable, 1 = Only alert when update is available, 2 = Normal Behavior.";
            prop.set((int)newConfig.checkForUpdates);
            prop = config.get("PopOffs.Appearance", "Transparency", (double)newConfig.transparency);
            prop.comment = "Number between 1.0 and 0.0 that controls how transparent the digits are. 1.0 means no transparency.";
            prop.set((double)newConfig.transparency);
            prop = config.get("Portrait.Appearance", "Lock_Mob_Position", newConfig.lockPosition);
            prop.comment = "When true, mobs in the portrait are locked in place. When false, they turn the same same as they are turning in the world.";
            prop.set(newConfig.lockPosition);
            prop = config.get("Portrait.Appearance", "Gui_Scale", (double)newConfig.guiScale);
            prop.comment = "Change the size of the portrait preview.";
            prop.set((double)newConfig.guiScale);
            prop = config.get("PopOffs.Appearance", "Build_TexturePack_Font", newConfig.CustomFont);
            prop.comment = "When building the font file for the damage indicator, use the texture pack specific font. Default true, set to false to use the default font.";
            prop.set(newConfig.CustomFont);
            prop = config.get("PopOffs.Appearance", "Scale_Smoothing_Filter", (double)newConfig.ScaleFilter);
            prop.comment = "Apply the Scale Smoothing filter to the font. Accepts any number between 2.0 and 4.0. All other numbers disable the filter. Defaults to 0.0(disabled). The Scale filter induces a smoother font, but can introduce fuzziness as a consequence. High values may increase startup time significantly when applied to high resolution fonts, or run java out of memory entirely.";
            prop.set((double)newConfig.ScaleFilter);
            prop.comment = "The color of the digits. Must use a 3 byte 16-bit(hex) RGB value here, also known as html notation. Defaults to FFFF00(Yellow).";
            newConfig.formattedDIColor = Integer.toHexString(newConfig.DIColor);
            prop = config.get("PopOffs.Appearance", "Color", newConfig.formattedDIColor);
            prop.set(newConfig.formattedDIColor);
            prop = config.get("PopOffs.Appearance", "Heal_Color", Integer.toHexString(newConfig.healColor & 0xFFFFFF));
            prop.comment = "The color of the digits on heals. Must use a 3 byte 16-bit(hex) RGB value here, also known as html notation. Defaults to 00FF00(Green).";
            prop.set(Integer.toHexString(newConfig.healColor));
            prop = config.get("Portrait.Appearance", "Range", newConfig.mouseoverRange);
            prop.comment = "The range that mouse overing mobs will display their health.";
            prop.set(newConfig.mouseoverRange);
            prop = config.get("Portrait.Behavior", "Enable", newConfig.portraitEnabled);
            prop.comment = "Set to false to Disable.";
            prop.set(newConfig.portraitEnabled);
            prop = config.get("PopOffs.Behavior", "Gravity", (double)newConfig.Gravity);
            prop.comment = "Change this to change the speed that the damage indicators fall, low numbers prevent falling numbers entirely. All positive numbers accepted, 0.8 is default.";
            prop.set((double)newConfig.Gravity);
            prop = config.get("PopOffs.Behavior", "Enabled", newConfig.popOffsEnabled);
            prop.comment = "Set this to false to disable damage pop offs. Typically Set using the in game gui.('.' Period is the default keybinding)";
            prop.set(newConfig.popOffsEnabled);
            prop = config.get("PopOffs.Behavior", "Bounce_Strength", (double)newConfig.BounceStrength);
            prop.comment = "This sets how powerful the initial bounce is. All positive numbers accepted, 1.5 is default.";
            prop.set((double)newConfig.BounceStrength);
            prop = config.get("PopOffs.Behavior", "Range", newConfig.packetrange);
            prop.comment = "This sets how far to send damage alerts to clients.";
            prop.set(newConfig.packetrange);
            prop = config.get("PopOffs.Behavior", "Size", (double)newConfig.Size);
            prop.comment = "The size of the digits that bounce off mobs, defaults to 3.0";
            prop.set((double)newConfig.Size);
            prop = config.get("Portrait.Behavior", "Portrait_Lifetime", newConfig.portraitLifetime);
            prop.comment = "How long the Portrait will stay after you are no longer targetting a mob. -1 to last forever or until the mob is unloaded.";
            prop.set(newConfig.portraitLifetime);
            prop = config.get("Portrait.Behavior", "Show Potion Effects", newConfig.enablePotionEffects);
            prop.comment = "How long the Portrait will stay after you are no longer targetting a mob. -1 to last forever or until the mob is unloaded.";
            prop.set(newConfig.enablePotionEffects);
            prop = config.get("Portrait.Behavior", "DebugHidesWindow", newConfig.DebugHidesWindow);
            prop.comment = "Should the debug window(F3) Hide the portrait window.";
            prop.set(newConfig.DebugHidesWindow);
            prop = config.get("Portrait.Behavior", "SupressBossHealth", newConfig.supressBossUI);
            prop.comment = "Hide boss health bars.";
            prop.set(newConfig.supressBossUI);
            prop = config.get("Portrait.Behavior", "AlternateRenderMethod", newConfig.alternateRenderingMethod);
            prop.comment = "If the portrait is not visible for you or renders incorrectly, set this to true.";
            prop.set(newConfig.alternateRenderingMethod);
            prop = config.get("Portrait.Behavior", "HighCompatibilityMode", newConfig.highCompatibilityMod);
            prop.comment = "Only set this to true if you have rendering problems. It can decrease preformance.";
            prop.set(newConfig.highCompatibilityMod);
            prop = config.get("PopOffs.Behavior", "ShowCriticalHits", newConfig.showCriticalStrikes);
            prop.comment = "Pop off critical when a critical strike lands.";
            prop.set(newConfig.showCriticalStrikes);
            prop = config.get("PopOffs.Appearance", "useDropShadows", newConfig.useDropShadows);
            prop.comment = "Use drop shadows on popoffs.";
            prop.set(newConfig.useDropShadows);
            prop = config.get("Internal", "version", "");
            prop.set("1");
            config.save();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static DIConfig mainInstance() {
        return diConfig;
    }

    private void loadConfig() {
        try {
            boolean flag = this.CONFIG_FILE.exists();
            Configuration config = new Configuration(this.CONFIG_FILE);
            config.load();
            if (flag && !config.get("Internal", "version", "0").getString().equals("1")) {
                DIConfig.overrideConfigAndSave(new DIConfig(this.CONFIG_FILE, 1));
                return;
            }
            config.addCustomCategoryComment("PopOffs", "These Settings effect the digits that bounce off mobs when they take damage.");
            config.addCustomCategoryComment("Portrait", "These Settings effect the current health portrait window on the hud.");
            config.addCustomCategoryComment("PopOffs.Behavior", "This subcategory holds behavioral settings to do with PopOffs.");
            config.addCustomCategoryComment("Portrait.Behavior", "This subcategory holds behavioral settings to do with Portraits.");
            config.addCustomCategoryComment("PopOffs.Appearance", "This subcategory holds appearance settings to do with PopOffs.");
            config.addCustomCategoryComment("Portrait.Appearance", "This subcategory holds appearance settings to do with Portraits.");
            config.addCustomCategoryComment("Internal", "Don't Modify these settings unless explicitly told to or if you know what you are doing.\n This could result in the lose of settings or an unexpected crash.");
            Property prop = config.get("PopOffs.Behavior", "Lifespan", this.Lifespan);
            prop.comment = "How long the damage indicator lasts before disappearing. Defaults to 12. Decimals not accepted, whole numbers only.";
            this.Lifespan = prop.getInt(this.Lifespan);
            prop.set(this.Lifespan);
            prop = config.get("Portrait.Appearance", "Portrait_xPos", this.locX);
            prop.comment = "This is typically set from the repositioning Gui in game, but added here for modpacks.";
            this.locX = prop.getInt(this.locX);
            prop = config.get("Portrait.Appearance", "Portrait_yPos", this.locY);
            prop.comment = "This is typically set from the repositioning Gui in game, but added here for modpacks.";
            this.locY = prop.getInt(this.locY);
            prop = config.get("Portrait.Appearance", "Portrait_Skin", this.selectedSkin);
            prop.comment = "The Currently Selected Skin Path.";
            this.selectedSkin = prop.getString();
            prop = config.get("PopOffs.Appearance", "Enable_Depth_Test", this.alwaysRender);
            prop.comment = "When true, objects in the environment can block the numbers";
            this.alwaysRender = prop.getBoolean(this.alwaysRender);
            prop = config.get("PopOffs.Behavior", "UpdateBehavior", (int)this.checkForUpdates);
            prop.comment = "0 = Disable, 1 = Only alert when update is available, 2 = Normal Behavior.";
            this.checkForUpdates = (byte)prop.getInt((int)this.checkForUpdates);
            prop = config.get("Portrait.Behavior", "SupressBossHealth", this.supressBossUI);
            prop.comment = "Hide boss health bars.";
            this.supressBossUI = prop.getBoolean(this.supressBossUI);
            prop = config.get("PopOffs.Appearance", "Transparency", (double)this.transparency);
            prop.comment = "Number between 1.0 and 0.0 that controls how transparent the digits are. 1.0 means no transparency.";
            this.transparency = (float)prop.getDouble((double)this.transparency);
            prop = config.get("Portrait.Appearance", "Gui_Scale", (double)this.guiScale);
            prop.comment = "Change the size of the portrait preview.";
            this.guiScale = (float)prop.getDouble((double)this.guiScale);
            prop.set((double)this.guiScale);
            prop = config.get("Portrait.Appearance", "Lock_Mob_Position", this.lockPosition);
            prop.comment = "When true, mobs in the portrait are locked in place. When false, they turn the same same as they are turning in the world.";
            this.lockPosition = prop.getBoolean(this.lockPosition);
            prop.set(this.lockPosition);
            prop = config.get("PopOffs.Appearance", "Build_TexturePack_Font", this.CustomFont);
            prop.comment = "When building the font file for the damage indicator, use the texture pack specific font. Default true, set to false to use the default font.";
            this.CustomFont = prop.getBoolean(this.CustomFont);
            prop.set(this.CustomFont);
            prop = config.get("PopOffs.Appearance", "Scale_Smoothing_Filter", (double)this.ScaleFilter);
            prop.comment = "Apply the Scale Smoothing filter to the font. Accepts any number between 2.0 and 4.0. All other numbers disable the filter. Defaults to 0.0(disabled). The Scale filter induces a smoother font, but can introduce fuzziness as a consequence. High values may increase startup time significantly when applied to high resolution fonts, or run java out of memory entirely.";
            this.ScaleFilter = (float)prop.getDouble((double)this.ScaleFilter);
            prop = config.get("PopOffs.Appearance", "Color", this.formattedDIColor);
            prop.comment = "The color of the digits. Must use a 3 byte or 4 byte(With alpha included) RGB value here, also known as html notation. Defaults to FFFF00(Yellow).";
            this.formattedDIColor = prop.getString();
            this.DIColor = (int)Long.parseLong(this.formattedDIColor, 16);
            prop = config.get("PopOffs.Appearance", "Heal_Color", this.formattedHealColor);
            prop.comment = "The color of the digits on heals. Must use a 3 byte or 4 byte(With alpha included) RGB value here, also known as html notation. Defaults to 00FF00(Green).";
            this.formattedHealColor = prop.getString();
            this.healColor = (int)Long.parseLong(this.formattedHealColor, 16);
            prop = config.get("Portrait.Appearance", "Range", this.mouseoverRange);
            prop.comment = "The range that mouse overing mobs will display their health.";
            this.mouseoverRange = prop.getInt(this.mouseoverRange);
            if (this.mouseoverRange <= 0) {
                this.mouseoverRange = 20;
            }
            if (this.mouseoverRange > 200) {
                this.mouseoverRange = 200;
            }
            prop.set(this.mouseoverRange);
            prop = config.get("Portrait.Behavior", "Enable", this.portraitEnabled);
            prop.comment = "Set to false to Disable.";
            this.portraitEnabled = prop.getBoolean(this.portraitEnabled);
            prop = config.get("PopOffs.Behavior", "Gravity", "1.600");
            prop.comment = "Change this to change the speed that the damage indicators fall, low numbers prevent falling numbers entirely. All positive numbers accepted, 0.8 is default.";
            try {
                this.Gravity = Float.valueOf(prop.getString()).floatValue();
            }
            catch (NumberFormatException ex) {
                this.Gravity = 0.8f;
                prop.set((double)this.Gravity);
            }
            prop = config.get("PopOffs.Behavior", "Enabled", this.popOffsEnabled);
            prop.comment = "Set this to false to disable damage pop offs. Typically Set using the in game gui.('.' Period is the default keybinding)";
            this.popOffsEnabled = prop.getBoolean(this.popOffsEnabled);
            prop = config.get("PopOffs.Behavior", "Bounce_Strength", (double)this.BounceStrength);
            prop.comment = "This sets how powerful the initial bounce is. All positive numbers accepted, 1.5 is default.";
            try {
                this.BounceStrength = Float.valueOf(prop.getString()).floatValue();
            }
            catch (NumberFormatException ex) {
                this.BounceStrength = 1.5f;
                prop.set((double)this.BounceStrength);
            }
            prop = config.get("PopOffs.Behavior", "Range", this.packetrange);
            prop.comment = "This sets how far to send damage alerts to clients.";
            this.packetrange = prop.getInt(this.packetrange);
            prop = config.get("PopOffs.Behavior", "Size", (double)this.Size);
            prop.comment = "The size of the digits that bounce off mobs, defaults to 3.0";
            try {
                this.Size = Float.valueOf(prop.getString()).floatValue();
            }
            catch (NumberFormatException ex) {
                this.Size = 3.0f;
                prop.set((double)this.Size);
            }
            prop = config.get("Portrait.Behavior", "Portrait_Lifetime", this.portraitLifetime);
            prop.comment = "How long the Portrait will stay after you are no longer targetting a mob. -1 to last forever or until the mob is unloaded.";
            this.portraitLifetime = prop.getInt(this.portraitLifetime);
            prop = config.get("Portrait.Behavior", "Show Potion Effects", this.enablePotionEffects);
            prop.comment = "How long the Portrait will stay after you are no longer targetting a mob. -1 to last forever or until the mob is unloaded.";
            this.enablePotionEffects = prop.getBoolean(this.enablePotionEffects);
            prop = config.get("Portrait.Behavior", "DebugHidesWindow", this.DebugHidesWindow);
            prop.comment = "Should the debug window(F3) Hide the portrait window.";
            this.DebugHidesWindow = prop.getBoolean(this.DebugHidesWindow);
            prop = config.get("Portrait.Behavior", "AlternateRenderMethod", this.alternateRenderingMethod);
            prop.comment = "If the portrait is not visible for you or renders incorrectly, set this to true.";
            this.alternateRenderingMethod = prop.getBoolean(this.alternateRenderingMethod);
            prop = config.get("Portrait.Behavior", "HighCompatibilityMode", this.highCompatibilityMod);
            prop.comment = "Only set this to true if you have rendering problems. It can decrease preformance.";
            this.highCompatibilityMod = prop.getBoolean(this.highCompatibilityMod);
            prop = config.get("PopOffs.Behavior", "ShowCriticalHits", this.showCriticalStrikes);
            prop.comment = "Pop off critical when a critical strike lands.";
            this.showCriticalStrikes = prop.getBoolean(this.showCriticalStrikes);
            prop = config.get("PopOffs.Appearance", "useDropShadows", this.useDropShadows);
            prop.comment = "Use drop shadows on popoffs.";
            this.useDropShadows = prop.getBoolean(this.useDropShadows);
            prop = config.get("Internal", "version", "");
            prop.set("1");
            config.save();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private RenderingHints populateHints() {
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hintsMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return new RenderingHints(hintsMap);
    }
}

