/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcs.command.profile;

import kamkeel.npcs.command.profile.CommandProfileBase;
import kamkeel.npcs.controllers.ProfileController;
import kamkeel.npcs.util.ColorUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class CommandProfileRename
extends CommandProfileBase {
    public String func_71517_b() {
        return "rename";
    }

    @Override
    public String getDescription() {
        return "Rename one of your profile slots. Only letters and spaces are allowed (max 20 characters).";
    }

    @Override
    public String getUsage() {
        return "<slotId> <newName>";
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        int slotId;
        if (!(sender instanceof EntityPlayer)) {
            ColorUtil.sendError(sender, "This command can only be used by a player.");
            return;
        }
        if (args.length < 2) {
            ColorUtil.sendError(sender, "Usage: " + this.getUsage());
            return;
        }
        try {
            slotId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            ColorUtil.sendError(sender, "Slot ID must be a number.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        String newName = sb.toString().trim();
        if (newName.length() > 20) {
            newName = newName.substring(0, 20);
        }
        if (!newName.matches("[A-Za-z ]+")) {
            ColorUtil.sendError(sender, "Invalid name. Only alphabetic characters and spaces are allowed.");
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (ProfileController.Instance.getProfile(player) == null) {
            ColorUtil.sendError(sender, "Profile not found.");
            return;
        }
        if (!ProfileController.Instance.getProfile(player).getSlots().containsKey(slotId)) {
            ColorUtil.sendError(sender, "Slot %d not found in your profile.", slotId);
            return;
        }
        ProfileController.Instance.getProfile(player).getSlots().get(slotId).setName(newName);
        ProfileController.Instance.save(player, ProfileController.Instance.getProfile(player));
        ColorUtil.sendResult(sender, "Successfully renamed slot %d to '%s'.", slotId, newName);
    }
}

