/*
 * Decompiled with CFR 0.152.
 */
package com.rneffects.network;

import com.rneffects.client.ClientEffectManager;
import com.rneffects.effects.RNEffectType;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class PacketAddEffect
implements IMessage {
    public int effectId;
    public int durationTicks;
    public int amplifier;

    public PacketAddEffect() {
    }

    public PacketAddEffect(int effectId, int durationTicks, int amplifier) {
        this.effectId = effectId;
        this.durationTicks = durationTicks;
        this.amplifier = amplifier;
    }

    public void fromBytes(ByteBuf buf) {
        this.effectId = buf.readInt();
        this.durationTicks = buf.readInt();
        this.amplifier = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.effectId);
        buf.writeInt(this.durationTicks);
        buf.writeInt(this.amplifier);
    }

    public static class Handler
    implements IMessageHandler<PacketAddEffect, IMessage> {
        public IMessage onMessage(PacketAddEffect msg, MessageContext ctx) {
            RNEffectType type = RNEffectType.byId(msg.effectId);
            if (type != null) {
                ClientEffectManager.enqueuePending(type, msg.durationTicks, msg.amplifier);
            }
            return null;
        }
    }
}

